set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9841090';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-10-11 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2104',
      '24323300',
      47,
      45,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      '444322',
      NULL,
      ' 4-23-1980',
      NULL,
      NULL,
      1.011142,
      NULL,
      3,
      1,
      0.721477,
      0.212737,
      NULL,
      NULL,
      0,
      2,
      0.660817,
      0,
      NULL,
      1,
      0.363892,
      3.558571,
      1,
      0.936016,
      NULL,
      1,
      5.491532,
      1.057397,
      1,
      NULL,
      4,
      1,
      1.181037,
      0,
      1.277818,
      0.720324,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      2.635107,
      1.535071,
      0.835126,
      1.715681,
      NULL,
      1.173613,
      1,
      1.083397,
      1,
      1,
      NULL,
      0.331651,
      1,
      2,
      NULL,
      3,
      2,
      1.181869,
      1.889125,
      3.751242,
      1,
      0,
      0,
      0.825189,
      NULL,
      NULL,
      1.061376,
      NULL,
      NULL,
      0.495529,
      0.383775,
      0.082053,
      1.099799,
      1,
      NULL,
      0.137498,
      0,
      0,
      0,
      1.861149,
      0,
      1,
      NULL,
      1,
      1.526912,
      1.999506,
      NULL,
      1,
      NULL,
      0.164995,
      NULL,
      NULL,
      1.206363,
      0,
      0.645903,
      5.139080,
      1,
      5,
      0.391991,
      NULL,
      5.871308,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2,
      0,
      3.560943,
      2,
      0.311619,
      0.443747,
      NULL,
      NULL,
      1.425743,
      NULL,
      0.734506,
      0,
      NULL,
      1.369338,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.940077,
      1,
      0,
      1,
      1.501193,
      NULL,
      1.414308,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.496210,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      2,
      3,
      1,
      0.816048,
      1,
      1,
      1,
      1,
      1.718072,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0,
      1.520907,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.629632,
      3,
      NULL,
      1.901288,
      1,
      2.973313,
      1,
      1,
      1.519348,
      0.706839,
      0,
      0.776327,
      0,
      0,
      NULL,
      0.510582,
      1.003918,
      1.667415,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.759513,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.664780,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.729225,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.160749,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.801235,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1.682898,
      NULL,
      0,
      NULL,
      1.719297,
      1,
      3.231298,
      '12110',
      '',
      '',
      1.777710,
      '',
      '',
      '',
      0.337589,
      '',
      '',
      '',
      4,
      5,
      2.229639,
      3.688226,
      3.142134,
      2.578420,
      NULL,
      2.825899,
      NULL);
commit;
end;
/


