set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9841090';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2005-5-04 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4311',
      '00140223',
      NULL,
      72.403144,
      '3322023',
      17,
      5,
      0.478603,
      3,
      '320214',
      1.737627,
      ' 7-20-1999',
      30,
      44.813193,
      1,
      NULL,
      2,
      NULL,
      0.539153,
      0.652600,
      0.596592,
      1.009164,
      0,
      0.481819,
      1.442237,
      0.444908,
      0.582489,
      0.840661,
      1.097282,
      2,
      0,
      NULL,
      NULL,
      1.375094,
      NULL,
      0,
      1,
      1,
      1.631473,
      0,
      1.517414,
      1.745786,
      3.026011,
      1.368911,
      NULL,
      NULL,
      1.675363,
      NULL,
      NULL,
      7.143261,
      3,
      0.603511,
      1.249952,
      1.676452,
      0,
      1,
      3,
      1,
      NULL,
      NULL,
      1,
      1,
      2,
      1,
      0,
      1,
      3.836007,
      3.332724,
      0.706092,
      NULL,
      NULL,
      6,
      0,
      2,
      0,
      1.431308,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.682594,
      1,
      1.789584,
      NULL,
      0,
      1.091151,
      1.161924,
      0,
      1.448603,
      1,
      NULL,
      0,
      NULL,
      0,
      1,
      1.094328,
      1,
      1,
      NULL,
      NULL,
      0,
      5.684381,
      1.510827,
      0,
      1,
      NULL,
      2,
      0,
      4,
      1,
      1.590372,
      NULL,
      1.979216,
      NULL,
      5,
      0,
      NULL,
      3,
      NULL,
      2,
      1,
      0,
      5,
      0,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.143601,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      2,
      0,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.557716,
      NULL,
      1.852499,
      0.626141,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1.177646,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1.035900,
      2.204459,
      NULL,
      1,
      0.670454,
      2.791737,
      0,
      NULL,
      1,
      1.391903,
      0,
      0.757478,
      NULL,
      0,
      0,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.882492,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.177260,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.810752,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      2,
      1.558988,
      '22213',
      '',
      '',
      1,
      '',
      '',
      '',
      0.655617,
      '',
      '',
      '',
      3.203458,
      4,
      1.808315,
      2.749900,
      NULL,
      NULL,
      3.155489,
      1.939999,
      1);
commit;
end;
/


