set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9682902';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1998-7-15 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '111',
      '40',
      2,
      10.396770,
      NULL,
      6,
      6,
      3,
      2,
      '422141',
      3.108077,
      NULL,
      31,
      6,
      0,
      NULL,
      4.036668,
      0.659311,
      1,
      NULL,
      1.435099,
      NULL,
      1.437461,
      0,
      1,
      NULL,
      5.241837,
      1,
      1.819301,
      NULL,
      3.207802,
      NULL,
      0,
      1.840087,
      2,
      0,
      1,
      1,
      4,
      0,
      3.294621,
      3.304476,
      0,
      0.709997,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1.101558,
      0,
      1,
      0,
      1,
      1,
      NULL,
      NULL,
      0,
      2.060777,
      0.576469,
      3,
      NULL,
      0.865168,
      1,
      1.592950,
      1,
      2.472218,
      NULL,
      4.834919,
      NULL,
      0.569855,
      3,
      NULL,
      0.923474,
      NULL,
      NULL,
      NULL,
      1.818362,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      2,
      0.668817,
      0.720736,
      0.367055,
      NULL,
      0.999868,
      1.676146,
      1,
      0,
      NULL,
      0.796456,
      NULL,
      0.434823,
      NULL,
      1.265955,
      NULL,
      0.399485,
      5.795829,
      0,
      NULL,
      5.784652,
      1.036281,
      5.282124,
      0.141297,
      0.994387,
      0.798817,
      NULL,
      2,
      2.088637,
      0,
      5,
      0.985314,
      3,
      NULL,
      1.658946,
      9.616409,
      0.422821,
      NULL,
      7,
      5.897173,
      4.351325,
      0.275184,
      4.343812,
      3.529437,
      3.143473,
      0.380403,
      1,
      5,
      0.685950,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.914606,
      NULL,
      0,
      1.193956,
      1.543606,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      6.043410,
      NULL,
      NULL,
      5.907107,
      0.234463,
      1.491641,
      0,
      NULL,
      0.650914,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      2.713748,
      1,
      NULL,
      NULL,
      2.051736,
      NULL,
      NULL,
      NULL,
      1.196720,
      0.678483,
      1.798273,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.555737,
      1,
      2,
      3,
      0.853902,
      0.037310,
      0.040263,
      1.295973,
      NULL,
      1.173610,
      0.244295,
      0.328030,
      0,
      0,
      1,
      NULL,
      1.673424,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.517270,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.146987,
      '14113',
      '',
      '',
      2,
      '40223',
      '',
      '',
      1.430562,
      '',
      '',
      '',
      1.374775,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


