set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9682902';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1998-12-16 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '312',
      '04',
      14.776713,
      NULL,
      '1133002',
      NULL,
      5,
      NULL,
      1,
      '233034',
      5.915493,
      ' 1- 2-1997',
      18,
      49,
      1,
      NULL,
      16,
      3.782260,
      0.428925,
      0,
      NULL,
      1.275835,
      1,
      0,
      1.650790,
      1.640942,
      0,
      1.896842,
      1.399596,
      NULL,
      1.996248,
      1.119442,
      1.952094,
      NULL,
      0.686498,
      1.376800,
      1.986738,
      1,
      NULL,
      0,
      2.582193,
      0.403210,
      3.648103,
      0.695541,
      NULL,
      NULL,
      0.800895,
      NULL,
      NULL,
      0,
      0.052428,
      1,
      1.189446,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.585778,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.722601,
      3,
      0.818408,
      NULL,
      NULL,
      0,
      0,
      0,
      NULL,
      0.798280,
      1,
      1,
      NULL,
      1,
      0.347860,
      NULL,
      0.051863,
      0,
      NULL,
      NULL,
      0,
      6,
      1,
      1.121129,
      3,
      NULL,
      NULL,
      1,
      1,
      0.850138,
      3.546342,
      NULL,
      0,
      0,
      6,
      0,
      1.211777,
      NULL,
      5.169651,
      4.503850,
      3,
      2.822447,
      2,
      2.335179,
      0.737135,
      1.556172,
      2,
      5,
      3,
      0.763793,
      1,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.012686,
      NULL,
      0,
      NULL,
      1.982328,
      1,
      0.031910,
      1.460888,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.691547,
      NULL,
      8.787302,
      0,
      3,
      NULL,
      1.845949,
      NULL,
      NULL,
      0,
      1.912800,
      4.011627,
      1.517579,
      0,
      NULL,
      NULL,
      NULL,
      7.507019,
      0.395831,
      5.214357,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1.015606,
      8,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.322263,
      NULL,
      NULL,
      1,
      NULL,
      2.115199,
      NULL,
      NULL,
      0.034765,
      0.612462,
      1,
      0.987220,
      0.428061,
      0.497895,
      NULL,
      1,
      0,
      1,
      1,
      1.523809,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      '44303',
      '',
      NULL,
      2.473918,
      '43112',
      '',
      '',
      0,
      '',
      '',
      '',
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


