set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9682902';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-7-15 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '042',
      '21',
      NULL,
      0,
      NULL,
      29,
      0,
      NULL,
      3,
      '241342',
      1.988316,
      NULL,
      21,
      56,
      1.503920,
      NULL,
      18,
      0,
      0.075059,
      0,
      1,
      0,
      1,
      0.939495,
      NULL,
      1.214327,
      NULL,
      0.720958,
      NULL,
      NULL,
      0.563791,
      1.206016,
      0.304854,
      1.578226,
      0,
      NULL,
      1.583073,
      0,
      5,
      NULL,
      2.844078,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1.437791,
      NULL,
      NULL,
      1,
      1,
      1.385419,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.955619,
      1,
      2.430155,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.445224,
      0.428922,
      NULL,
      0,
      1.053458,
      NULL,
      NULL,
      0,
      1.055843,
      0,
      0,
      0.321713,
      0,
      NULL,
      1,
      1.852411,
      1.969236,
      1,
      0,
      NULL,
      1,
      4.713949,
      0.676651,
      6.601251,
      3.437417,
      1.277878,
      3.612494,
      1,
      2.593388,
      1.131501,
      4.413933,
      1.467154,
      NULL,
      0,
      0,
      1,
      1.718550,
      4,
      5,
      0,
      NULL,
      1.218161,
      9,
      NULL,
      4.378774,
      5.581663,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      9.044390,
      1.401779,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.247555,
      0.826976,
      1,
      1,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      3,
      NULL,
      1.920414,
      0.594373,
      7.748227,
      1.642282,
      0,
      NULL,
      NULL,
      NULL,
      4.741151,
      1.439907,
      1.560973,
      NULL,
      NULL,
      0,
      0.205506,
      NULL,
      NULL,
      NULL,
      1.210988,
      5.923988,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      NULL,
      1.666831,
      0,
      NULL,
      NULL,
      NULL,
      1.585355,
      0.914945,
      0,
      1.398573,
      1,
      0.659624,
      1,
      NULL,
      0,
      1.638751,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.065441,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2.671920,
      NULL,
      '',
      '',
      1.943506,
      NULL,
      '',
      '',
      2.595982,
      '22203',
      '',
      '',
      4,
      6.401434,
      0.596150,
      1,
      3,
      NULL,
      2.984064,
      NULL,
      NULL);
commit;
end;
/


