set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9682902';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-12-07 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '102',
      NULL,
      20,
      4.635612,
      NULL,
      17.955794,
      NULL,
      2.219337,
      0,
      '300111',
      2.694070,
      ' 1-23-1978',
      NULL,
      20.045738,
      0,
      NULL,
      11,
      2.849597,
      1.540813,
      NULL,
      0.397381,
      1.739536,
      0,
      NULL,
      3,
      NULL,
      2.607174,
      0,
      0.634828,
      1.322206,
      1.712781,
      NULL,
      2.705096,
      0.162429,
      0.122220,
      0.448519,
      NULL,
      1,
      5.541374,
      0,
      0,
      NULL,
      1,
      1,
      NULL,
      NULL,
      1.279306,
      NULL,
      NULL,
      1,
      NULL,
      1.118432,
      1.727067,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.003607,
      1,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      1.383486,
      NULL,
      0.625925,
      1,
      0,
      0.282786,
      1,
      NULL,
      1,
      0.165465,
      NULL,
      0.066522,
      NULL,
      1.974880,
      NULL,
      NULL,
      NULL,
      0.249521,
      5,
      0,
      1,
      5.082076,
      1,
      5,
      NULL,
      5,
      1.505703,
      NULL,
      0,
      NULL,
      0,
      4,
      0.430409,
      NULL,
      NULL,
      1.445679,
      0.127231,
      5,
      NULL,
      0,
      6,
      2,
      3.753504,
      0,
      NULL,
      1.469652,
      NULL,
      NULL,
      1,
      1.110691,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.592406,
      NULL,
      NULL,
      NULL,
      0.785357,
      1.904893,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.275877,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      0,
      0,
      1.007662,
      3.670851,
      4,
      0,
      1.792146,
      NULL,
      NULL,
      NULL,
      0.270051,
      NULL,
      1,
      NULL,
      1.966632,
      0,
      2,
      1.055403,
      NULL,
      NULL,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      0.590851,
      0,
      NULL,
      1.507700,
      NULL,
      1.460556,
      NULL,
      3,
      1.406491,
      0,
      NULL,
      NULL,
      NULL,
      0,
      0.826222,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.028370,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.222784,
      '34231',
      '',
      NULL,
      2.843800,
      NULL,
      '',
      NULL,
      0,
      '',
      '',
      '',
      0.737438,
      0.328482,
      3,
      0.469186,
      3.457569,
      1,
      0.544318,
      3,
      3);
commit;
end;
/


