set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9682902';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-12-18 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '224',
      '11044000',
      13.812314,
      38,
      NULL,
      35,
      0,
      2.145597,
      NULL,
      NULL,
      0.195844,
      '11-14-1986',
      10.482374,
      NULL,
      NULL,
      NULL,
      1,
      0.310383,
      0.694632,
      1.745870,
      0,
      1,
      0,
      NULL,
      0,
      0.164196,
      4.181352,
      0.591488,
      NULL,
      0,
      0,
      0.954680,
      NULL,
      1,
      1,
      0,
      0.495097,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0.386945,
      NULL,
      NULL,
      1.374059,
      NULL,
      NULL,
      NULL,
      NULL,
      1.130705,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.020022,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.182644,
      1.450313,
      NULL,
      0.915996,
      NULL,
      0,
      NULL,
      1,
      1,
      1.910486,
      1,
      1.844791,
      NULL,
      0.761096,
      1.271430,
      1.237071,
      0.760955,
      0,
      NULL,
      0.588165,
      4.515554,
      0.663746,
      0.824984,
      0,
      0,
      1,
      1.222184,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      4,
      1.203996,
      NULL,
      1,
      3,
      NULL,
      2.671760,
      NULL,
      5,
      4.024871,
      NULL,
      5.879211,
      1.757336,
      5,
      1.516809,
      NULL,
      NULL,
      6.670937,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.154444,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      0,
      1.036680,
      0,
      NULL,
      NULL,
      3.507843,
      1.480282,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0.271694,
      1.108375,
      1.218336,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.254871,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.734599,
      0.872609,
      0.018250,
      1,
      3.915798,
      NULL,
      0.663998,
      1.096970,
      1,
      1,
      1.537404,
      1,
      1.242274,
      0.477119,
      1.128586,
      1,
      0,
      1.336216,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.595029,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      '10423',
      NULL,
      '',
      3,
      '32332',
      '',
      '',
      0.684784,
      '',
      NULL,
      '',
      NULL,
      2.121590,
      0,
      0,
      2.309519,
      3,
      NULL,
      2.264774,
      3.007946);
commit;
end;
/


