set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9682902';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-5-21 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '424',
      '03444212',
      16,
      3.712137,
      '1000244',
      82,
      5,
      0,
      0,
      '201301',
      2.361746,
      '10-15-1996',
      27.178289,
      NULL,
      0,
      NULL,
      10,
      3.384825,
      0.434484,
      0,
      1,
      0,
      0.061759,
      0,
      1,
      0,
      1.465290,
      NULL,
      1.067266,
      NULL,
      1.800005,
      0.982549,
      5.622398,
      1,
      0.335958,
      0.653914,
      1.427873,
      1,
      1.016883,
      1,
      NULL,
      1,
      0.365635,
      0,
      NULL,
      NULL,
      0.998355,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0,
      NULL,
      1,
      2,
      0,
      1,
      NULL,
      2,
      NULL,
      1,
      NULL,
      2,
      0,
      1,
      2.813163,
      2.040888,
      0.314599,
      0.077737,
      1,
      1,
      0,
      0,
      1.429530,
      1.705018,
      NULL,
      NULL,
      0.323422,
      NULL,
      NULL,
      1.523450,
      0.942485,
      1,
      1,
      0,
      0,
      0,
      1.746919,
      0.879372,
      NULL,
      0,
      1,
      0.695877,
      0.708105,
      0.936408,
      1.354663,
      1,
      0,
      1.410891,
      NULL,
      1,
      2,
      0,
      NULL,
      NULL,
      1.942744,
      1.571702,
      1,
      NULL,
      1,
      1.185146,
      0,
      0,
      NULL,
      2,
      0,
      1,
      1,
      3,
      5,
      3,
      0,
      1.211040,
      NULL,
      0.853732,
      5,
      7,
      NULL,
      1,
      NULL,
      NULL,
      2.337531,
      1.452728,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.786286,
      NULL,
      0,
      NULL,
      1,
      0,
      1.853870,
      1.052684,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.248053,
      3,
      1.697242,
      1.768123,
      NULL,
      0,
      7.363161,
      2.312905,
      1,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      0,
      0.123259,
      1,
      0.579343,
      NULL,
      NULL,
      NULL,
      1,
      1.124353,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.167459,
      3,
      2,
      3.341386,
      2,
      2,
      1,
      0,
      0.671109,
      0,
      1,
      NULL,
      0,
      NULL,
      0,
      0.228460,
      NULL,
      1.575914,
      1,
      0.348507,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      '',
      NULL,
      0,
      '44021',
      '',
      '',
      0,
      NULL,
      '',
      '',
      3.448198,
      2,
      2.806916,
      NULL,
      NULL,
      1,
      4.145174,
      2.537523,
      3.604246);
commit;
end;
/


