set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9682902';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-7-08 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '020',
      '00204223',
      66.648529,
      48.987120,
      '0322321',
      42,
      4,
      3,
      1,
      '042130',
      3.788985,
      NULL,
      1,
      33.344089,
      1.396620,
      NULL,
      0.560205,
      2.516964,
      NULL,
      1,
      1.920639,
      0.291657,
      NULL,
      NULL,
      1.295830,
      0.182765,
      2.495750,
      NULL,
      0,
      0.946374,
      0.084588,
      NULL,
      2.201003,
      1.703789,
      3,
      0.014588,
      1,
      NULL,
      NULL,
      0,
      3.730227,
      0,
      3.767319,
      1,
      NULL,
      NULL,
      1.142070,
      NULL,
      NULL,
      1,
      0.891781,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.327011,
      1,
      0.306312,
      1,
      0.313577,
      1.565210,
      1,
      NULL,
      0.543202,
      1,
      1,
      1,
      0,
      1.539471,
      0.094966,
      0,
      NULL,
      1,
      NULL,
      NULL,
      0,
      2.382384,
      0,
      2.165186,
      1.516349,
      0,
      1,
      1.489665,
      NULL,
      1,
      5.529333,
      0,
      1,
      0,
      4.636767,
      0.820910,
      0.497355,
      1,
      1.168444,
      3,
      3,
      3.021518,
      2.126100,
      0,
      1.376408,
      0,
      0.679137,
      2.321901,
      0,
      NULL,
      NULL,
      7,
      0.540643,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      1.722879,
      NULL,
      0.485474,
      1.786852,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.769678,
      NULL,
      NULL,
      NULL,
      NULL,
      0.646193,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.560100,
      3.265549,
      1.555217,
      NULL,
      NULL,
      NULL,
      5.693667,
      NULL,
      NULL,
      0.394501,
      NULL,
      0,
      7.710966,
      0,
      NULL,
      NULL,
      1,
      5,
      1.968114,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.997180,
      2.461750,
      1,
      3,
      2,
      0.034964,
      2,
      0,
      NULL,
      1.417310,
      0.791097,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.270631,
      '40332',
      NULL,
      '',
      1,
      '22402',
      NULL,
      '',
      1.919417,
      '',
      '',
      '',
      5,
      NULL,
      NULL,
      0,
      NULL,
      0.397624,
      1,
      NULL,
      0.084572);
commit;
end;
/


