set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9682902';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-12-04 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2443',
      '33000100',
      34.076579,
      NULL,
      NULL,
      26,
      5,
      1,
      NULL,
      '044313',
      3.526879,
      ' 5-22-1998',
      NULL,
      45.082418,
      1,
      NULL,
      0.338752,
      0,
      0.579463,
      0,
      1.826187,
      1.294346,
      1,
      NULL,
      0,
      NULL,
      5,
      1,
      1.628329,
      NULL,
      1.288641,
      1,
      5,
      1,
      1.520521,
      1.036872,
      0.511408,
      NULL,
      1.934629,
      1,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.581333,
      NULL,
      NULL,
      1.771608,
      1.824654,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.087112,
      0.061975,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.825084,
      NULL,
      NULL,
      0.768038,
      0,
      NULL,
      1,
      NULL,
      0.181404,
      1,
      1.547622,
      0.820853,
      1,
      1,
      NULL,
      1.802019,
      NULL,
      0,
      0.929706,
      NULL,
      1.062688,
      4,
      1.536286,
      1.546323,
      3,
      1,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.304655,
      1,
      0,
      4.513539,
      2.241826,
      NULL,
      0.894854,
      4.427861,
      0.010419,
      0,
      5.018194,
      4,
      2.279639,
      2,
      0.165391,
      NULL,
      NULL,
      9.948941,
      1.437420,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.220990,
      1,
      NULL,
      1,
      NULL,
      NULL,
      0.779608,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.586493,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      1.262391,
      1.675160,
      NULL,
      NULL,
      NULL,
      0,
      1.540777,
      0.726884,
      NULL,
      1,
      2,
      NULL,
      0,
      NULL,
      NULL,
      0.699363,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.120517,
      NULL,
      0.538610,
      0.530320,
      1,
      1,
      NULL,
      2.124826,
      NULL,
      0,
      0.676140,
      1,
      1.515119,
      1.508700,
      NULL,
      1.543245,
      0.622883,
      0,
      0.217742,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.967422,
      '01023',
      '',
      '',
      NULL,
      '30341',
      '',
      '',
      0,
      '',
      '',
      '',
      1.966456,
      0,
      2.561415,
      0,
      NULL,
      1,
      1,
      1,
      2);
commit;
end;
/


