set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9682902';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-7-07 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      84.948178,
      11,
      '4232442',
      NULL,
      NULL,
      0,
      NULL,
      '433110',
      NULL,
      NULL,
      35.551820,
      49,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0.203708,
      0.237082,
      NULL,
      1,
      1,
      2.072712,
      0,
      5.295379,
      1.073206,
      1.979977,
      0,
      0,
      0,
      1.335407,
      1,
      0.018007,
      0.683619,
      1.462634,
      0.662199,
      4.161934,
      1,
      NULL,
      0.835836,
      0,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.684657,
      0.765731,
      0.175935,
      0.421283,
      NULL,
      1.465578,
      2.691127,
      0,
      1.138945,
      NULL,
      NULL,
      0.220690,
      0,
      2.396396,
      NULL,
      3,
      0,
      1,
      NULL,
      0,
      1,
      4,
      1,
      2,
      1,
      1.230350,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.293629,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      1,
      0,
      1.980544,
      1.239070,
      1.185601,
      0.877567,
      0.080902,
      1,
      1,
      1,
      NULL,
      1.551719,
      NULL,
      NULL,
      0,
      1.765543,
      0.725364,
      3.846374,
      NULL,
      2.765175,
      NULL,
      5.219317,
      0.511941,
      4,
      1,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      4.403225,
      3.390626,
      NULL,
      3.087517,
      0.566475,
      NULL,
      3.236950,
      4,
      1,
      2.441310,
      1,
      NULL,
      NULL,
      6.774707,
      0.271364,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.647654,
      NULL,
      1,
      0,
      1,
      0.075417,
      1.426506,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.541495,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      0,
      2,
      0.429258,
      0.101386,
      0,
      4.029582,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      3,
      1,
      1,
      1,
      5.159726,
      NULL,
      NULL,
      NULL,
      0,
      4.825833,
      0.646672,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.395456,
      2.111550,
      3.949881,
      3.227383,
      NULL,
      NULL,
      3,
      0.052943,
      3.364086,
      0,
      1.666162,
      0,
      0.416436,
      1,
      0.423370,
      0.672160,
      1.770405,
      NULL,
      1.961934,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      '02424',
      '',
      '',
      3.898393,
      '24111',
      '',
      '',
      1,
      '',
      '',
      '',
      3,
      NULL,
      1,
      1,
      NULL,
      2.259822,
      0.169197,
      2,
      2);
commit;
end;
/


