set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9682902';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2005-1-21 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3132',
      NULL,
      10.466639,
      0,
      '3230100',
      61.007928,
      3,
      2,
      NULL,
      NULL,
      3,
      '11-10-1995',
      NULL,
      35,
      NULL,
      NULL,
      1.322777,
      0.415332,
      0,
      NULL,
      0,
      NULL,
      NULL,
      0.286152,
      NULL,
      0,
      NULL,
      1.540672,
      0.872008,
      0.752803,
      1,
      0,
      5.903335,
      1,
      NULL,
      1,
      0,
      1,
      5.157648,
      NULL,
      NULL,
      0,
      1,
      1.560662,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      0.423988,
      1.127665,
      0,
      3,
      2.008924,
      0,
      0.981928,
      NULL,
      NULL,
      1.362724,
      1,
      0.273151,
      1.190379,
      4.928200,
      1.888179,
      0,
      3,
      1,
      2,
      3.028262,
      1,
      NULL,
      NULL,
      0.462389,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.201389,
      1,
      0.252761,
      1.902185,
      1,
      1,
      1.284039,
      0,
      NULL,
      0,
      NULL,
      1,
      0,
      NULL,
      1,
      0.805404,
      NULL,
      0.368291,
      2.034187,
      0,
      1.834702,
      NULL,
      0,
      5.278711,
      3.120874,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      1,
      5,
      1.458031,
      NULL,
      1.324680,
      3,
      7,
      0.983940,
      5,
      2.789440,
      NULL,
      0.770523,
      2,
      NULL,
      1.620560,
      NULL,
      NULL,
      NULL,
      NULL,
      0.539068,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.692754,
      0,
      1,
      0.168048,
      1,
      NULL,
      0.329690,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      0,
      0,
      2.840267,
      5,
      3,
      1.982894,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0.768206,
      0,
      1,
      0,
      NULL,
      1,
      NULL,
      NULL,
      0,
      8.778671,
      0.294579,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.282017,
      3,
      1,
      1,
      NULL,
      0,
      NULL,
      1,
      0,
      NULL,
      0.986806,
      NULL,
      1,
      0.020105,
      0.110270,
      0,
      0.229835,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.247182,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.820962,
      '12211',
      NULL,
      '',
      3.958168,
      NULL,
      NULL,
      '',
      1.818712,
      '',
      '',
      '',
      NULL,
      1.736694,
      NULL,
      NULL,
      3,
      NULL,
      0,
      1,
      1.664289);
commit;
end;
/


