set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9128147';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1994-5-13 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2',
      NULL,
      NULL,
      NULL,
      '3014424',
      52,
      6,
      NULL,
      NULL,
      NULL,
      2,
      ' 8-27-2001',
      4.867277,
      NULL,
      0.453122,
      NULL,
      2,
      1,
      0.246089,
      NULL,
      1.510402,
      1,
      1,
      0.754489,
      1,
      0,
      8,
      1.135604,
      4,
      0.570964,
      1,
      NULL,
      NULL,
      NULL,
      5,
      5,
      NULL,
      0.441748,
      NULL,
      0,
      5,
      3,
      3,
      0.063346,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.384423,
      0.666658,
      NULL,
      1,
      NULL,
      2.327917,
      2.003158,
      NULL,
      1.704422,
      0.512931,
      NULL,
      1,
      3,
      1,
      NULL,
      0,
      0,
      0.565610,
      9.923281,
      4,
      7,
      0,
      0,
      1.377597,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.114096,
      0.347310,
      0,
      1.675684,
      1.829121,
      3.492997,
      1,
      0.504701,
      1.701560,
      1.414904,
      NULL,
      0.559156,
      NULL,
      0.168017,
      1.364204,
      0.210401,
      0.006508,
      0,
      NULL,
      1,
      4.878335,
      1,
      1.452110,
      NULL,
      2,
      1.626545,
      0,
      NULL,
      0,
      NULL,
      2.609930,
      NULL,
      0,
      NULL,
      3.299741,
      NULL,
      0,
      NULL,
      NULL,
      2,
      2,
      1.545396,
      NULL,
      8,
      0,
      4,
      5,
      2,
      NULL,
      NULL,
      1.692756,
      0.242343,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      2,
      1.848745,
      0.008821,
      NULL,
      0.592097,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.240137,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      2.570689,
      1.716748,
      NULL,
      NULL,
      NULL,
      0.547571,
      1.825656,
      5.192180,
      NULL,
      0.370005,
      0,
      0.209694,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.184201,
      0,
      1.951108,
      0,
      3.182699,
      1.652145,
      2,
      0,
      3.188097,
      2.965055,
      0,
      1,
      NULL,
      1.655149,
      0,
      1.058578,
      0.071117,
      1.991008,
      1.760423,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.380528,
      '24140',
      '',
      '',
      0,
      '',
      '',
      '',
      NULL,
      NULL,
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


