set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9128147';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1995-1-26 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '2',
      NULL,
      NULL,
      '1313340',
      71.442654,
      0,
      2.622133,
      3,
      '201102',
      NULL,
      NULL,
      36,
      NULL,
      0,
      NULL,
      5.694814,
      1.570242,
      1,
      0.654745,
      1.276750,
      3.283335,
      0.980403,
      0.787192,
      0,
      NULL,
      1,
      0,
      NULL,
      3,
      2,
      2.071790,
      3.548309,
      NULL,
      6,
      0.303245,
      3,
      0.177716,
      8,
      1,
      1.733502,
      NULL,
      2,
      1.336192,
      NULL,
      NULL,
      0.157228,
      NULL,
      NULL,
      2,
      1,
      0,
      3.721445,
      NULL,
      NULL,
      3.220059,
      3,
      2.692079,
      NULL,
      1.676809,
      1.784153,
      NULL,
      3.359929,
      2,
      0.160978,
      3.688604,
      3.147043,
      1.695658,
      0.895361,
      2.764184,
      4,
      7.021773,
      1,
      2,
      3,
      1,
      NULL,
      NULL,
      1.481222,
      NULL,
      NULL,
      0,
      1.153818,
      NULL,
      0.586765,
      0,
      1,
      4.671329,
      1.905820,
      NULL,
      3,
      1,
      1.882723,
      0.726179,
      0,
      0,
      0.230493,
      0.359506,
      1.726369,
      0,
      NULL,
      1,
      1.105242,
      2.561590,
      1.466950,
      NULL,
      0.129918,
      2.196984,
      1,
      6,
      1.042312,
      5.948198,
      3.614842,
      5.171173,
      0,
      NULL,
      NULL,
      7,
      4,
      1.481739,
      9,
      0.186916,
      10.792056,
      6,
      8.015555,
      NULL,
      NULL,
      2.100067,
      5.942461,
      NULL,
      0,
      1.291450,
      0.061923,
      0.007609,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.624346,
      1.758645,
      1,
      0,
      1.384168,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.204584,
      NULL,
      NULL,
      NULL,
      NULL,
      0.867145,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      2.004164,
      0.598323,
      NULL,
      NULL,
      NULL,
      0.282838,
      1,
      3,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.057306,
      3.152490,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.282085,
      1,
      1,
      2,
      0,
      1,
      0.682378,
      2,
      NULL,
      1.120978,
      2,
      0,
      0.014451,
      1.729347,
      1,
      0.665476,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '03403',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      '',
      1,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


