set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9128147';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1995-6-06 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0',
      '1',
      NULL,
      NULL,
      '4320012',
      42.022655,
      3,
      1,
      3,
      '343022',
      1,
      NULL,
      14.571644,
      NULL,
      1,
      NULL,
      8.944621,
      2,
      0.345918,
      0.486360,
      0,
      0,
      1.627653,
      1.431028,
      NULL,
      1.204586,
      NULL,
      0,
      6,
      NULL,
      0,
      1.128709,
      2,
      1.600103,
      6,
      NULL,
      3.638690,
      NULL,
      1,
      1,
      4.058180,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.564662,
      NULL,
      NULL,
      1,
      1,
      1,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.993830,
      1,
      0,
      3.233013,
      1,
      2.559464,
      NULL,
      0.659505,
      1,
      1.345946,
      0.652571,
      2.029920,
      0,
      NULL,
      NULL,
      1.786369,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      1.491553,
      0,
      0.480924,
      1.821718,
      NULL,
      0.301110,
      0,
      1.392282,
      1.841059,
      NULL,
      1,
      5.964734,
      0,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      4.576583,
      NULL,
      1.329902,
      1.086027,
      1.365823,
      3,
      1,
      4,
      NULL,
      5.567977,
      3,
      5.932049,
      0,
      6,
      NULL,
      NULL,
      0.827760,
      7,
      7,
      5.374804,
      NULL,
      5.963374,
      NULL,
      2,
      0,
      4,
      1.699911,
      0.697613,
      0.338693,
      NULL,
      1,
      1.464876,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.084788,
      1.960543,
      2,
      NULL,
      1.597963,
      1,
      0.535527,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.021793,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.114417,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.656496,
      5,
      0.551138,
      1,
      0,
      1.371514,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      3.692644,
      NULL,
      2,
      3.852690,
      0,
      0.537214,
      1.170189,
      0,
      NULL,
      1.279251,
      0.936627,
      1,
      NULL,
      1,
      1.163515,
      0.440700,
      0.328995,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.873776,
      '40201',
      NULL,
      '',
      0.215212,
      '',
      '',
      '',
      0,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


