set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '0130661';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-12-09 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0234',
      '2',
      31.965297,
      53.444771,
      '2113144',
      9.639191,
      NULL,
      2,
      0,
      '020210',
      2,
      NULL,
      NULL,
      57,
      0.501210,
      NULL,
      1.660216,
      2.935608,
      0,
      0.916570,
      1,
      1.820193,
      1.214952,
      NULL,
      0.761056,
      NULL,
      5,
      0.575221,
      NULL,
      NULL,
      0.730900,
      0,
      1,
      0.720613,
      1,
      1.030906,
      1,
      1.349593,
      4.410179,
      1,
      1.074273,
      0.953809,
      1,
      1.743324,
      NULL,
      NULL,
      0.782898,
      NULL,
      NULL,
      1.994270,
      0,
      0.578280,
      1.016631,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.814071,
      1.165819,
      NULL,
      0.553773,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.086622,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      1.409102,
      0.833289,
      0.461788,
      1.908847,
      NULL,
      0,
      0.053465,
      1,
      0,
      1,
      0.857789,
      0,
      NULL,
      1.088240,
      1,
      NULL,
      0,
      0,
      1.742164,
      3,
      0,
      2,
      NULL,
      3.888380,
      1,
      1.215039,
      0.377807,
      1,
      0.004707,
      1,
      NULL,
      NULL,
      5.432540,
      1.302357,
      NULL,
      1.927194,
      3.831781,
      5,
      1.707342,
      0.246835,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.836598,
      1,
      1,
      1.052046,
      NULL,
      1.360992,
      1.276429,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.990373,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      2,
      NULL,
      0.230182,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.045866,
      3,
      4,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.026004,
      3.556488,
      3,
      0.277374,
      3,
      1.481705,
      0.476253,
      2,
      NULL,
      NULL,
      1.887274,
      NULL,
      1.494620,
      1.309640,
      0.762813,
      0,
      0.011768,
      NULL,
      1,
      0.728278,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      '32202',
      NULL,
      NULL,
      0.599126,
      '',
      '',
      '',
      1,
      '',
      '',
      '',
      4,
      3.302106,
      NULL,
      0.199290,
      0,
      0.147478,
      0,
      3.973521,
      1);
commit;
end;
/


