set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9000419';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-2-13 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '031',
      '33',
      6,
      2.373445,
      '0043031',
      7.388226,
      6,
      3,
      2,
      '240200',
      0.441188,
      ' 6- 8-1996',
      0.389119,
      17,
      1.441184,
      NULL,
      2,
      0.280708,
      0.315292,
      0,
      NULL,
      1,
      NULL,
      0,
      2.668787,
      0.949501,
      0,
      1,
      NULL,
      1,
      0.738169,
      4,
      0.671418,
      0,
      1.677718,
      1.206886,
      2,
      2,
      5.691515,
      1,
      2,
      1.672656,
      3,
      1,
      NULL,
      NULL,
      3.446882,
      2,
      3.373226,
      NULL,
      0.981487,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.269045,
      3.037641,
      NULL,
      3.879893,
      1,
      2,
      1,
      1.148708,
      NULL,
      NULL,
      NULL,
      0.578655,
      4.046872,
      0,
      1.211623,
      NULL,
      0.791583,
      3,
      NULL,
      0.409193,
      NULL,
      0.656858,
      0.821336,
      0.838400,
      0.532320,
      1.290558,
      0.869577,
      0.984157,
      1.196632,
      1.633579,
      0,
      0,
      NULL,
      0,
      0.559552,
      0.011557,
      0.133976,
      1.151211,
      1.995666,
      NULL,
      NULL,
      6,
      3.430157,
      NULL,
      2.447804,
      1.947861,
      1,
      NULL,
      0.682118,
      5,
      2,
      7.139671,
      9,
      NULL,
      6.049113,
      2,
      3.983561,
      NULL,
      1.131523,
      3.426556,
      6,
      0.628010,
      1.460923,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      NULL,
      1.350239,
      0,
      1.628899,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      6,
      0,
      0.988517,
      3.566535,
      0.171691,
      0,
      2,
      1.083108,
      5,
      0,
      2.104788,
      1,
      NULL,
      NULL,
      NULL,
      7.127929,
      0.163621,
      7,
      8.510886,
      7,
      2,
      5.855378,
      0.853961,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.466860,
      4,
      5,
      4,
      NULL,
      NULL,
      0.764455,
      0.375647,
      0,
      NULL,
      3,
      3,
      2.350430,
      1,
      0,
      NULL,
      2,
      NULL,
      1,
      0,
      1.109456,
      NULL,
      NULL,
      NULL,
      0.064471,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      '30242',
      '',
      0,
      NULL,
      NULL,
      NULL,
      3.636624,
      NULL,
      '',
      '',
      2.305793,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


