set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9000419';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-7-26 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '003',
      '43',
      0,
      NULL,
      '2333224',
      11.612194,
      NULL,
      1,
      2,
      NULL,
      4,
      ' 4-19-2003',
      40.959641,
      65.135796,
      1.995511,
      NULL,
      2,
      0,
      2,
      1,
      1.500462,
      1.880350,
      0,
      1,
      2.123851,
      NULL,
      2.845855,
      NULL,
      3.203029,
      1.904866,
      NULL,
      NULL,
      2,
      1.148380,
      1,
      1.780009,
      1.650816,
      NULL,
      1.048527,
      NULL,
      1,
      0.561148,
      0.932738,
      NULL,
      NULL,
      NULL,
      NULL,
      0.337460,
      NULL,
      1,
      1,
      1.806918,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      0.447554,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      0.305848,
      1.514948,
      5.186785,
      1.815472,
      1.844938,
      NULL,
      1.943327,
      0.102524,
      0,
      0,
      1.418513,
      NULL,
      0,
      0.998185,
      NULL,
      1,
      NULL,
      NULL,
      1,
      0.080533,
      1,
      1.027830,
      NULL,
      1.709853,
      1.023246,
      NULL,
      NULL,
      1,
      0,
      2.021910,
      0,
      NULL,
      1.442558,
      3.842091,
      7.558503,
      0,
      1.875729,
      NULL,
      0.552729,
      1.647970,
      0,
      NULL,
      5.155450,
      0,
      6.758156,
      1.810668,
      1,
      2.810049,
      0.775434,
      NULL,
      3.399094,
      1.821051,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      0,
      1,
      3,
      1,
      1,
      0.127052,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      3,
      NULL,
      1.608445,
      5.935210,
      1,
      2.351435,
      0,
      0.806584,
      4.194373,
      1,
      1,
      0.440414,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1,
      6,
      2.860737,
      1,
      4,
      1.653907,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      6.000422,
      8.328675,
      1.413532,
      1.449290,
      3,
      0.555190,
      3.995821,
      1,
      2.141464,
      1,
      3,
      3,
      1.207597,
      0.448390,
      1,
      0.438419,
      1.894773,
      1.865397,
      1,
      0,
      0,
      1.131689,
      1.694610,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3.046761,
      NULL,
      '21101',
      '',
      0,
      '',
      '',
      '',
      NULL,
      '2042',
      '',
      '',
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


