set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9000419';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-7-08 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '304',
      '40',
      NULL,
      33.294697,
      '3223401',
      40.963611,
      NULL,
      0.020473,
      NULL,
      NULL,
      5.254958,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0.601362,
      1.212118,
      1.706775,
      NULL,
      0.642726,
      NULL,
      0.491005,
      0.591133,
      2,
      1,
      6.712938,
      1.015746,
      NULL,
      1,
      1,
      0.603078,
      4.261825,
      0,
      NULL,
      1.531230,
      NULL,
      0.412674,
      5.397698,
      NULL,
      NULL,
      2,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.289182,
      0,
      1.688271,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.520784,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      5.625897,
      0.908963,
      4,
      0.060989,
      1,
      NULL,
      1,
      0,
      0.290816,
      1,
      0,
      0,
      NULL,
      NULL,
      1.667180,
      1,
      1.442002,
      NULL,
      0,
      0.425313,
      1,
      0.530318,
      NULL,
      1,
      0,
      2.683168,
      NULL,
      NULL,
      NULL,
      NULL,
      4.599199,
      NULL,
      NULL,
      2.317737,
      3,
      NULL,
      4.082717,
      6,
      6.268909,
      0.738348,
      3.589757,
      0.665588,
      NULL,
      NULL,
      1.518723,
      0,
      1,
      NULL,
      NULL,
      2.354401,
      1.691645,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.617029,
      1,
      2,
      0,
      1,
      0.589474,
      1.322258,
      1.797725,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3,
      1.272968,
      NULL,
      NULL,
      0,
      1.667108,
      1,
      NULL,
      NULL,
      1.401821,
      1,
      NULL,
      NULL,
      NULL,
      0.976252,
      1.180109,
      4.405654,
      7,
      3.627113,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.912908,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.035350,
      3,
      NULL,
      1.258734,
      3,
      1.698505,
      2,
      3,
      1,
      2.558536,
      2,
      NULL,
      1.209375,
      1.610531,
      1.646629,
      0,
      0.294986,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      '44233',
      '20324',
      '',
      1,
      '',
      NULL,
      NULL,
      0,
      '0422',
      '',
      '',
      5.504126,
      3.146145,
      2.456437,
      2,
      NULL,
      2.698015,
      3,
      NULL,
      0);
commit;
end;
/


