set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9000419';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-2-09 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '000',
      '33210013',
      14,
      46,
      '2021034',
      45,
      3,
      1.763918,
      2,
      '042412',
      0,
      ' 9- 5-1998',
      10,
      45.097086,
      0,
      NULL,
      NULL,
      0.213748,
      NULL,
      NULL,
      1,
      0,
      1,
      1.751779,
      3,
      0,
      1,
      1,
      4.702130,
      1,
      0,
      NULL,
      NULL,
      5.929217,
      1.999575,
      0,
      0,
      0,
      6.187282,
      1,
      3,
      0.896945,
      0,
      0.682796,
      NULL,
      NULL,
      1.414010,
      NULL,
      5,
      1,
      1.552094,
      NULL,
      1.345681,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.729444,
      1.592359,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.336919,
      0.504656,
      1,
      1.458992,
      2.674629,
      1,
      0.748883,
      1,
      1.930996,
      1.936211,
      1.622257,
      1,
      1,
      1,
      1.882088,
      0.903525,
      0.164747,
      0.650246,
      0,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      1.859372,
      0,
      0,
      3.867130,
      1,
      0.179606,
      0.202043,
      NULL,
      1.471158,
      5,
      3,
      0,
      0.737865,
      9,
      NULL,
      6,
      NULL,
      NULL,
      NULL,
      NULL,
      3.456632,
      4.017611,
      0.635027,
      NULL,
      NULL,
      1.228812,
      2.378808,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.550908,
      1.655043,
      NULL,
      0,
      NULL,
      0,
      0,
      1.717104,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      3,
      3,
      3.476518,
      4,
      1,
      NULL,
      0,
      1,
      0.292343,
      0.877229,
      0.586631,
      2,
      1,
      2.068146,
      2.925152,
      NULL,
      0,
      NULL,
      3.708409,
      2.634631,
      0,
      0.921024,
      NULL,
      NULL,
      NULL,
      NULL,
      4.097486,
      0,
      2,
      2,
      1.722387,
      4.722840,
      1,
      0.229521,
      1,
      NULL,
      3.238561,
      0,
      NULL,
      1.186705,
      NULL,
      2,
      1,
      3,
      0,
      0.221867,
      NULL,
      1.055754,
      1,
      1.123078,
      1,
      0.729793,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.825492,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      NULL,
      '10000',
      '',
      0,
      '',
      '',
      '',
      0,
      NULL,
      '',
      '',
      0,
      1.339597,
      NULL,
      2.034579,
      NULL,
      3.581239,
      2,
      2,
      2.027821);
commit;
end;
/


