set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9000419';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-7-17 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '43321123',
      NULL,
      57.260611,
      '0241240',
      73,
      0,
      2,
      3,
      NULL,
      0.887350,
      '11- 3-1992',
      15.925577,
      3.544964,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      1,
      1.352148,
      3.121099,
      0.668718,
      3,
      1,
      0,
      0.574433,
      NULL,
      1,
      4.192548,
      0.808249,
      NULL,
      1,
      1,
      1.322572,
      NULL,
      NULL,
      1,
      0.940699,
      0.849871,
      1,
      NULL,
      NULL,
      0,
      0,
      3,
      NULL,
      1,
      0,
      1,
      0,
      0,
      1.202403,
      1.874788,
      0,
      3.665184,
      NULL,
      2,
      3,
      3.150113,
      2,
      2,
      0,
      0.669434,
      0.602644,
      0.377586,
      1.370064,
      0.233572,
      7.516019,
      NULL,
      NULL,
      0.656796,
      1.328630,
      NULL,
      NULL,
      2,
      2,
      1.758427,
      1.424022,
      NULL,
      3,
      0,
      2.459444,
      0,
      1,
      0,
      NULL,
      0.553264,
      0,
      0.278216,
      NULL,
      1.206916,
      0,
      NULL,
      0.240635,
      0,
      1,
      NULL,
      1,
      1.250746,
      0,
      1,
      1,
      NULL,
      NULL,
      1.009211,
      5,
      3,
      3,
      1,
      1.243895,
      1,
      0,
      2.771542,
      3.195182,
      NULL,
      0,
      NULL,
      3,
      6.535138,
      NULL,
      0,
      0,
      5.631738,
      0,
      5,
      NULL,
      0.270880,
      NULL,
      4.453121,
      0.829030,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.201248,
      1,
      1,
      NULL,
      NULL,
      1,
      0.785647,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      6,
      2,
      1,
      11.758621,
      2,
      0,
      0.527961,
      1.832873,
      11,
      NULL,
      1.668466,
      0.980343,
      0,
      0,
      NULL,
      0.670083,
      NULL,
      NULL,
      0,
      2,
      1,
      1.830152,
      NULL,
      NULL,
      NULL,
      1.333185,
      11,
      0.565771,
      3,
      3,
      1,
      NULL,
      0.843346,
      1.906314,
      0.449012,
      1.678545,
      0.768962,
      NULL,
      2.330229,
      1.742913,
      2.021228,
      0.119154,
      0.535664,
      1,
      2.069783,
      NULL,
      NULL,
      0,
      0.687927,
      NULL,
      0.716984,
      1,
      1,
      1.005039,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.795016,
      '32033',
      '30130',
      '',
      NULL,
      '',
      '',
      '',
      2,
      '4001',
      '',
      '',
      3.833230,
      1.717862,
      3.678876,
      3,
      1,
      NULL,
      NULL,
      1.724648,
      3);
commit;
end;
/


