set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9000419';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-1-29 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '442',
      NULL,
      NULL,
      40.761423,
      '2410221',
      3.201647,
      NULL,
      1,
      2,
      '144140',
      1.872035,
      ' 8-23-1974',
      35,
      60,
      1.084756,
      NULL,
      0,
      1,
      0.784532,
      NULL,
      NULL,
      1,
      0,
      NULL,
      0.821857,
      0,
      NULL,
      NULL,
      1.382369,
      1.853401,
      0.606519,
      5,
      0,
      NULL,
      0.233008,
      0,
      0,
      0,
      5.443356,
      0,
      3.094013,
      1,
      0.736557,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      0.625838,
      1.716754,
      0,
      1.579590,
      0.802898,
      3,
      0.828820,
      0.389451,
      1,
      0.231719,
      0.749898,
      1,
      NULL,
      NULL,
      1,
      1,
      NULL,
      3,
      0.277011,
      0.417254,
      2,
      0,
      2,
      1,
      0,
      NULL,
      NULL,
      0.491097,
      NULL,
      NULL,
      NULL,
      0.629938,
      3.131582,
      NULL,
      1.890937,
      1,
      NULL,
      0.675061,
      0,
      1,
      NULL,
      1.518753,
      0,
      0.716332,
      1.428562,
      1.049575,
      0.934500,
      0.032296,
      1.032261,
      NULL,
      0,
      0.844491,
      1,
      1,
      1,
      1.572284,
      1.181149,
      NULL,
      2.192818,
      NULL,
      3.654075,
      0.991444,
      1,
      NULL,
      2,
      1.995994,
      0,
      2.605785,
      2.794779,
      7,
      4,
      1,
      1,
      NULL,
      NULL,
      1,
      NULL,
      3,
      3.161531,
      0,
      1,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.720092,
      0,
      0,
      0,
      1,
      NULL,
      1.260820,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.060729,
      NULL,
      0.554224,
      2,
      2.259610,
      NULL,
      1.251104,
      3.423849,
      0.790576,
      0.791793,
      1,
      4.882705,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      2,
      5,
      0,
      0.623164,
      NULL,
      NULL,
      NULL,
      0,
      7,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1.985016,
      0.270283,
      1,
      0.670347,
      0,
      1.665271,
      NULL,
      3.060260,
      1,
      1,
      1.576465,
      0.181804,
      1.438724,
      NULL,
      0.710137,
      0,
      1.442258,
      1.305256,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.178643,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      5.709090,
      '33024',
      '40021',
      '',
      1.605297,
      '',
      '',
      '',
      2.981547,
      '3323',
      '',
      '',
      4.799641,
      1.827222,
      0,
      NULL,
      2.394217,
      2,
      0.636695,
      0,
      NULL);
commit;
end;
/


