set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9000419';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-8-21 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '130',
      '43001014',
      49,
      10,
      '3403044',
      88.592900,
      3,
      0,
      2,
      '423112',
      5,
      ' 3-20-1978',
      24,
      65.445400,
      NULL,
      NULL,
      NULL,
      0.351935,
      2.634152,
      0,
      0.899689,
      0.244982,
      0.530024,
      0.502008,
      3.012988,
      0,
      5,
      1.915001,
      1,
      0.831221,
      1.824103,
      5,
      5.011891,
      2,
      1.196801,
      0.546011,
      1,
      NULL,
      5,
      1,
      4,
      2,
      NULL,
      0.483739,
      NULL,
      NULL,
      1.132104,
      NULL,
      NULL,
      0,
      0,
      1,
      1,
      1.153445,
      1,
      2.905931,
      NULL,
      1,
      NULL,
      1.682643,
      0,
      1,
      3,
      0.077292,
      NULL,
      1.782389,
      1,
      0.432462,
      0.776664,
      1,
      NULL,
      3,
      0,
      2,
      NULL,
      0.163153,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.713136,
      5,
      NULL,
      NULL,
      0.922816,
      0,
      0.939989,
      1,
      1,
      NULL,
      0.050189,
      0,
      NULL,
      1,
      1.185806,
      0.792428,
      0,
      1,
      NULL,
      0,
      0.741066,
      1.782883,
      NULL,
      0.994272,
      NULL,
      0,
      0,
      5,
      0,
      5.872514,
      2.355547,
      0.923514,
      NULL,
      5.001700,
      1,
      5.117760,
      NULL,
      9.330478,
      6,
      NULL,
      0.030508,
      1.445497,
      3,
      NULL,
      1,
      7.203576,
      4,
      2.705053,
      NULL,
      0,
      3.732525,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.679012,
      1.079339,
      0,
      0,
      1,
      NULL,
      1,
      1.038794,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.161974,
      2,
      1,
      9,
      2.921075,
      0.969092,
      0.235546,
      0.439246,
      8.669512,
      NULL,
      3.819072,
      0.041650,
      NULL,
      NULL,
      NULL,
      1.670394,
      0.057988,
      2,
      2,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0,
      0.900947,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.011126,
      3.589770,
      1.862643,
      1,
      3.345206,
      1,
      0,
      NULL,
      1.477887,
      3,
      0,
      0,
      1.088098,
      0.067476,
      NULL,
      1,
      NULL,
      0.898074,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      '34003',
      '42124',
      NULL,
      0.515369,
      '',
      '',
      '',
      1,
      '3240',
      '',
      '',
      3.131760,
      1,
      NULL,
      NULL,
      0.616057,
      NULL,
      2,
      3.253479,
      3);
commit;
end;
/


