set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9000419';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-1-14 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '101',
      '44140021',
      26.673701,
      12,
      '3420004',
      89,
      NULL,
      3,
      2,
      '014024',
      0.656103,
      ' 8-19-1985',
      8.306466,
      5.415140,
      0,
      NULL,
      1.913669,
      0.749425,
      1,
      1,
      0,
      1.066611,
      1,
      NULL,
      NULL,
      1.979688,
      1,
      0,
      2,
      1.148130,
      0,
      1,
      3,
      3,
      1,
      NULL,
      0.238331,
      2,
      1.669807,
      NULL,
      5.605724,
      NULL,
      NULL,
      1.861864,
      NULL,
      NULL,
      0.431345,
      NULL,
      NULL,
      6,
      NULL,
      1,
      NULL,
      1,
      0.781769,
      0.578354,
      0.518083,
      0,
      2.466263,
      NULL,
      1.016351,
      NULL,
      0,
      2,
      0.042339,
      NULL,
      1,
      0.947593,
      3.361599,
      0.320417,
      0,
      1.255403,
      0,
      1,
      1.650101,
      1,
      NULL,
      NULL,
      0.522281,
      NULL,
      NULL,
      1,
      1,
      0,
      0,
      1.821977,
      0.914868,
      1.387865,
      0.089071,
      1.913933,
      NULL,
      1,
      NULL,
      0.288486,
      0,
      1.854630,
      1,
      0.385686,
      1,
      1,
      NULL,
      NULL,
      1,
      1.224782,
      1.563790,
      0.625199,
      NULL,
      1.452447,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      3.207307,
      0,
      0.453166,
      0,
      6,
      0,
      8,
      NULL,
      1,
      1,
      NULL,
      NULL,
      2,
      5.355227,
      1,
      6.137727,
      1,
      0,
      1,
      NULL,
      0.457903,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.685668,
      0.234567,
      1,
      1,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.702730,
      NULL,
      NULL,
      1,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      7,
      4,
      3.597199,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0.805259,
      9.336740,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.019259,
      NULL,
      3.640420,
      0,
      NULL,
      1,
      NULL,
      NULL,
      1,
      0,
      2.587728,
      NULL,
      0,
      NULL,
      1,
      1,
      0,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.716565,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      '30221',
      '34321',
      '',
      0,
      '',
      NULL,
      '',
      0.744316,
      '4344',
      '',
      NULL,
      3,
      5,
      1.148027,
      2.499938,
      0,
      NULL,
      1,
      4.789809,
      0.106492);
commit;
end;
/


