set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9000419';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-1-14 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '420',
      '30030204',
      68.974961,
      37,
      '4141040',
      60,
      0,
      1.891816,
      NULL,
      '224004',
      1,
      NULL,
      51.030881,
      30,
      0.981799,
      NULL,
      1.484737,
      0.064148,
      0,
      1.820959,
      2,
      0,
      1,
      0,
      1.309548,
      NULL,
      4.738287,
      0.993986,
      0,
      1.047438,
      0.083853,
      0.760689,
      1,
      1.474214,
      5,
      1,
      1.241331,
      NULL,
      1.873315,
      1,
      NULL,
      NULL,
      1,
      1.570728,
      NULL,
      NULL,
      1.378205,
      NULL,
      NULL,
      NULL,
      0.743374,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.457902,
      0.990990,
      1.615776,
      0.993778,
      0,
      0,
      0,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.414717,
      NULL,
      NULL,
      0,
      2.739705,
      1.931355,
      0.404532,
      1.091812,
      NULL,
      1.205191,
      0.103210,
      0,
      NULL,
      0,
      NULL,
      1,
      1,
      1.905824,
      1.191346,
      NULL,
      NULL,
      NULL,
      1.467716,
      1,
      1.340169,
      1.720386,
      1,
      1,
      NULL,
      NULL,
      1,
      NULL,
      3.280133,
      1.071335,
      7.015835,
      NULL,
      0,
      NULL,
      7.350483,
      6.492030,
      6.744073,
      5.932915,
      3.815784,
      7.428114,
      3,
      4,
      9,
      4,
      1,
      NULL,
      NULL,
      NULL,
      1.169158,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.325745,
      0.539804,
      2,
      1,
      0,
      0,
      1.807749,
      0.317991,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      1,
      1.341959,
      2,
      0,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.167366,
      NULL,
      9.766760,
      NULL,
      5,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.573878,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.929116,
      1,
      NULL,
      0.992578,
      2.335974,
      1.552715,
      1.387173,
      0,
      1,
      3.784925,
      1,
      1,
      0,
      0.538242,
      0.483503,
      1.862684,
      0.714351,
      1.708205,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.655739,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.198459,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.931627,
      NULL,
      NULL,
      NULL,
      NULL,
      1.947264,
      0.946601,
      1,
      NULL,
      1,
      1,
      NULL,
      1,
      0.194073,
      '41310',
      '04333',
      '',
      1,
      '',
      '',
      '',
      0.486210,
      '0422',
      NULL,
      '',
      0,
      NULL,
      2,
      3.726898,
      NULL,
      1.655179,
      0,
      1.083337,
      2);
commit;
end;
/


