set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9000419';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-7-14 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '30124221',
      NULL,
      63,
      '1003404',
      3.835865,
      NULL,
      NULL,
      0,
      NULL,
      4,
      NULL,
      46.592920,
      25.774683,
      1,
      NULL,
      2.697752,
      2.870143,
      1,
      1,
      2.020139,
      1,
      1,
      1.842370,
      0.274852,
      0.030340,
      4.794903,
      0.043384,
      1.729689,
      1,
      0.984107,
      NULL,
      2,
      NULL,
      2.417021,
      1.358805,
      0,
      2.655019,
      4,
      NULL,
      NULL,
      3.934597,
      1.357494,
      0.911865,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      0.648723,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.629309,
      1,
      2,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.220036,
      1,
      1.807006,
      0.819681,
      2,
      0.225974,
      1,
      1.887977,
      0,
      1,
      1.629562,
      0,
      0.092088,
      1.078925,
      0.490638,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1,
      1.367042,
      0.962602,
      0.054960,
      0,
      NULL,
      NULL,
      0,
      6.929146,
      2,
      0,
      3.407537,
      2,
      0.059618,
      5.426055,
      3.094457,
      1,
      2,
      9,
      2.717313,
      5,
      4,
      2,
      1,
      NULL,
      NULL,
      NULL,
      5,
      3.231581,
      NULL,
      1.469717,
      0.930511,
      1.265407,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.313538,
      0,
      NULL,
      0,
      0.401429,
      0.234563,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      2,
      NULL,
      6,
      NULL,
      0,
      3.902154,
      3.121014,
      1.955566,
      1.907606,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.739471,
      1,
      5,
      0,
      5.370219,
      1,
      0.379591,
      NULL,
      NULL,
      NULL,
      NULL,
      7.120102,
      1.585697,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.560319,
      1,
      0.162033,
      NULL,
      3.897766,
      NULL,
      3.360043,
      NULL,
      1,
      3,
      NULL,
      0.870697,
      0.739870,
      1.629296,
      0.175936,
      1.123164,
      0.306913,
      0.944705,
      1,
      0.451365,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.755978,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '22023',
      '22142',
      NULL,
      NULL,
      '',
      '',
      '',
      3,
      NULL,
      '',
      '',
      4.058863,
      3,
      1,
      NULL,
      0,
      0.129037,
      3.362067,
      0,
      3.115460);
commit;
end;
/


