set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9000419';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-3-22 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '23402120',
      59.470069,
      38,
      NULL,
      NULL,
      4,
      NULL,
      0,
      '044301',
      NULL,
      ' 9- 7-1987',
      NULL,
      54.818345,
      1,
      NULL,
      NULL,
      2.559641,
      0,
      0,
      1.340114,
      1,
      0.175684,
      1.769341,
      NULL,
      1,
      NULL,
      0,
      1,
      NULL,
      NULL,
      0.200394,
      NULL,
      0.472506,
      NULL,
      NULL,
      1,
      3.972315,
      6.067917,
      1,
      NULL,
      1,
      0,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.747017,
      NULL,
      1.003761,
      1.289562,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.372432,
      1,
      NULL,
      0,
      0,
      NULL,
      0.438665,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.097165,
      0,
      4.232617,
      0.923652,
      3.589738,
      1,
      NULL,
      0.067841,
      1.666898,
      0.423273,
      1,
      0.185844,
      1.851289,
      0.701411,
      1.068759,
      1.566792,
      0.148044,
      0,
      1.773749,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.423539,
      1.883382,
      NULL,
      0,
      NULL,
      NULL,
      4.117783,
      3,
      0,
      0.669566,
      NULL,
      2.837947,
      2,
      2.033439,
      7.005199,
      0.226415,
      8,
      NULL,
      4,
      3.967466,
      3.993388,
      5,
      NULL,
      0,
      NULL,
      1.668340,
      0.129890,
      2.180942,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      0,
      0,
      2.951792,
      0.548691,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      9,
      2.929399,
      2.205369,
      3,
      0.499517,
      1.983068,
      0.208991,
      1.916140,
      6,
      7,
      0,
      0.758944,
      0,
      3,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      5,
      1.466644,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      1.524068,
      3,
      0,
      NULL,
      NULL,
      0,
      3,
      0,
      NULL,
      1,
      0.662402,
      0,
      1,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      4.357484,
      '21110',
      '03034',
      '33334',
      NULL,
      '',
      NULL,
      '',
      3.891915,
      '0400',
      NULL,
      '',
      2,
      4,
      3,
      NULL,
      0,
      NULL,
      2.804220,
      2,
      1.888903);
commit;
end;
/


