set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9000419';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-8-11 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4002',
      NULL,
      4,
      38.838117,
      NULL,
      40.297632,
      1,
      3.906054,
      NULL,
      NULL,
      5.025166,
      ' 4- 0-1979',
      53.059517,
      32,
      0.850013,
      NULL,
      NULL,
      1.005308,
      NULL,
      1,
      3.752480,
      1.396012,
      1.908693,
      1,
      1,
      1,
      1.585503,
      1.584794,
      1,
      NULL,
      1,
      2,
      2.078267,
      1.637764,
      6.709448,
      2.970410,
      0.628763,
      0.320862,
      6.841054,
      1,
      5,
      1,
      3.893096,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      0.588975,
      1.722949,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      5,
      NULL,
      3.360087,
      0,
      0,
      NULL,
      0.961161,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      2,
      NULL,
      4.141525,
      NULL,
      0,
      1,
      0.548667,
      NULL,
      0,
      0.936887,
      0.617620,
      1,
      1,
      0,
      0,
      1,
      1,
      NULL,
      0.932990,
      NULL,
      1.894551,
      1,
      1,
      1.552212,
      NULL,
      NULL,
      0.462312,
      2,
      0.798839,
      0.670867,
      NULL,
      1.735185,
      0.609859,
      2.412013,
      0.875349,
      1.125983,
      2,
      5.570628,
      0.345724,
      NULL,
      0.248938,
      NULL,
      3,
      4,
      5.030643,
      1.214765,
      1.110271,
      0.550306,
      NULL,
      6.428923,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.907176,
      1.889925,
      1,
      1,
      1,
      1,
      1.665765,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      6.415837,
      1.261183,
      3.129763,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.489731,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.217371,
      0,
      3.579987,
      3,
      0,
      2,
      3,
      NULL,
      NULL,
      NULL,
      1,
      4.191307,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.910991,
      0.275487,
      1,
      0,
      0.387907,
      NULL,
      3,
      1.864748,
      2,
      0.249201,
      1.025775,
      1.476980,
      0,
      NULL,
      1,
      NULL,
      1.769699,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      4.558134,
      '43013',
      '01412',
      '42103',
      NULL,
      '',
      NULL,
      '',
      1.266258,
      '2402',
      '',
      '',
      NULL,
      4.760340,
      0.356673,
      NULL,
      1,
      NULL,
      2.226363,
      2,
      3);
commit;
end;
/


