set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9000419';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2005-1-13 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1214',
      '10424100',
      50.845635,
      75.456003,
      '2412424',
      NULL,
      3,
      3,
      2,
      '044141',
      0,
      '11- 5-2002',
      17.659873,
      17.462649,
      NULL,
      NULL,
      3.895295,
      0,
      0.554358,
      1.803023,
      0,
      0.193667,
      NULL,
      1,
      1.844273,
      NULL,
      5,
      1,
      1,
      1,
      NULL,
      0,
      1.614289,
      1,
      7,
      1.370783,
      1,
      1,
      4.174740,
      1,
      NULL,
      NULL,
      1.433279,
      1.291215,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      0,
      0,
      1.403307,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      2,
      0,
      0,
      0.692361,
      0.605647,
      NULL,
      NULL,
      0.897039,
      NULL,
      NULL,
      NULL,
      1.141579,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      1,
      NULL,
      1.520583,
      0,
      0,
      0,
      0,
      0.198338,
      1,
      0,
      NULL,
      0,
      NULL,
      0.541937,
      1,
      1.807244,
      0.031637,
      5,
      1.907940,
      5.998673,
      NULL,
      0.539684,
      0.786924,
      3.920030,
      0.281871,
      5,
      0.728765,
      1,
      0.572989,
      0.978643,
      4,
      5,
      9,
      0,
      6,
      4.002993,
      NULL,
      4,
      2.215653,
      3,
      1,
      1,
      5,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.251008,
      0.031774,
      1,
      1,
      1,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      1,
      1,
      2.190912,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.693233,
      NULL,
      NULL,
      NULL,
      NULL,
      0.381289,
      9,
      NULL,
      6.740979,
      0,
      NULL,
      1,
      NULL,
      NULL,
      0.212755,
      7,
      0.739052,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.791010,
      3,
      2,
      NULL,
      2.401296,
      1,
      NULL,
      3.328277,
      0,
      1.842067,
      NULL,
      0.465353,
      0,
      1,
      1.395753,
      0,
      0,
      1,
      0,
      0.671324,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '13130',
      '40024',
      NULL,
      NULL,
      '',
      '',
      '',
      2.576821,
      '2032',
      '',
      '',
      2.427499,
      3.664082,
      0.039370,
      4.347025,
      3,
      0,
      NULL,
      1.379035,
      0.256616);
commit;
end;
/


