set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9717517';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-9-18 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '244',
      '22032340',
      55,
      71.987347,
      '4134323',
      61.421197,
      4,
      3,
      1,
      '144002',
      5.707656,
      '11-18-1991',
      NULL,
      40.471731,
      0,
      NULL,
      NULL,
      NULL,
      0,
      0.563632,
      3,
      3,
      1.344748,
      3.600815,
      0,
      1,
      3.381666,
      1,
      NULL,
      0,
      1.417614,
      1,
      0.453076,
      1,
      1,
      1,
      1,
      0,
      NULL,
      1,
      1.071248,
      NULL,
      0,
      1,
      NULL,
      NULL,
      1.624440,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.158180,
      1,
      0.629926,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.151419,
      1,
      2,
      0.162556,
      4,
      0.559711,
      NULL,
      0.999476,
      0,
      1.760072,
      1,
      0,
      1.231716,
      3.211431,
      1.721547,
      NULL,
      NULL,
      1.067093,
      1.773625,
      NULL,
      NULL,
      1,
      4.824317,
      5,
      1.372836,
      NULL,
      NULL,
      NULL,
      2.720007,
      NULL,
      NULL,
      0,
      1,
      0.599328,
      1.463363,
      0,
      0.130738,
      NULL,
      NULL,
      5,
      4,
      NULL,
      0.968792,
      NULL,
      3,
      0,
      1.064983,
      1,
      NULL,
      NULL,
      NULL,
      2.255120,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1.269186,
      1,
      4.713328,
      0.140898,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.818854,
      NULL,
      NULL,
      NULL,
      2.507655,
      NULL,
      NULL,
      3.015634,
      NULL,
      0,
      3.713812,
      1.692280,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.603599,
      0.970963,
      5.814301,
      0,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.332291,
      NULL,
      1,
      2.559325,
      NULL,
      0.149112,
      NULL,
      2,
      2,
      0.334976,
      1.187854,
      0.375166,
      0.974109,
      0.398582,
      0,
      1,
      1,
      1.600886,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.549457,
      '41302',
      '',
      '',
      1,
      '',
      '',
      '',
      0.413665,
      NULL,
      '',
      NULL,
      5.996980,
      6,
      2,
      6.704432,
      0,
      NULL,
      0.202381,
      NULL,
      0);
commit;
end;
/


