set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9717517';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-2-23 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3103',
      '30111130',
      32,
      48.644294,
      '1011214',
      86.138816,
      6,
      0.428609,
      0,
      '034201',
      NULL,
      NULL,
      13.869654,
      199.706303,
      0,
      NULL,
      10.846823,
      0,
      NULL,
      0.414313,
      0,
      1.759166,
      3,
      3.808821,
      1,
      0,
      0,
      NULL,
      0.034964,
      1.626664,
      1.936876,
      1.285068,
      2,
      0,
      0.638361,
      0.668340,
      NULL,
      NULL,
      2,
      1,
      1,
      3,
      1.099197,
      1.959969,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.294047,
      1.435305,
      0.408681,
      1.977791,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.436993,
      1.053737,
      1,
      1,
      0.210407,
      1.294127,
      1.162194,
      0.499479,
      1.024476,
      1.041910,
      1.734418,
      1,
      NULL,
      0.542001,
      1,
      1.375516,
      0,
      0,
      NULL,
      0.878917,
      1.916311,
      2.358541,
      0,
      0.378443,
      NULL,
      NULL,
      0,
      NULL,
      0.538722,
      0,
      3,
      NULL,
      0.312236,
      4,
      NULL,
      0.728097,
      NULL,
      2.456370,
      1.582574,
      1.982985,
      0,
      3,
      2,
      4.021308,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1.045874,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.928667,
      0,
      1,
      NULL,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.053488,
      1.940546,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      2.033762,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1.359777,
      1.262223,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.725218,
      1.923512,
      NULL,
      0,
      0.868446,
      0.071195,
      1.636251,
      1.051777,
      0,
      0.785201,
      0.581469,
      1.132909,
      0,
      0,
      0.861590,
      NULL,
      0.351070,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.295739,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2,
      '31324',
      '',
      '',
      0,
      '',
      '',
      '',
      NULL,
      '',
      '',
      '',
      5.535872,
      2.543135,
      2,
      3.028621,
      2.805845,
      1,
      NULL,
      0,
      0.695289);
commit;
end;
/


