set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9717517';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-8-11 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0433',
      '12012203',
      35.184176,
      25,
      '0311423',
      NULL,
      4,
      2.678835,
      1,
      '022143',
      NULL,
      ' 1- 6-1990',
      170,
      17.687150,
      NULL,
      NULL,
      0.108117,
      NULL,
      0,
      0.309196,
      1.448925,
      NULL,
      3.688083,
      NULL,
      NULL,
      1,
      4.633452,
      1.608423,
      0,
      0.866023,
      1.419642,
      NULL,
      1.004655,
      0,
      0.893722,
      0.720427,
      1.152055,
      1,
      2,
      1,
      0,
      0.892185,
      0.010105,
      NULL,
      NULL,
      NULL,
      1.716330,
      NULL,
      NULL,
      0.495788,
      0,
      0.174058,
      1.265186,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1.804417,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.065879,
      0,
      0,
      1,
      1,
      0.501575,
      1.430070,
      1,
      NULL,
      1,
      NULL,
      0,
      0.058023,
      5,
      0,
      0.994896,
      0,
      0,
      0,
      NULL,
      1.202354,
      1,
      1,
      2.922846,
      0.682423,
      1,
      3,
      NULL,
      5,
      0,
      1,
      NULL,
      0.992788,
      3.380894,
      4.816567,
      2,
      0,
      5,
      2,
      NULL,
      2.619974,
      NULL,
      1.502568,
      NULL,
      3.492982,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      2,
      1.861792,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.878799,
      1.398019,
      1,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      2,
      2,
      0,
      NULL,
      NULL,
      1.437921,
      0.276497,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      7.711485,
      1.904618,
      1.390588,
      NULL,
      1.813528,
      NULL,
      NULL,
      NULL,
      0.890065,
      NULL,
      0.979919,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.973621,
      1,
      0,
      0,
      NULL,
      NULL,
      1.290538,
      2,
      NULL,
      2.721959,
      1.591433,
      1.318745,
      1.749682,
      1.213664,
      0,
      1.866962,
      NULL,
      NULL,
      1.889793,
      0.375413,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.345444,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      '03423',
      '',
      '',
      0.610870,
      '',
      '',
      '',
      1,
      '',
      '',
      NULL,
      3.854074,
      0.652903,
      3,
      2.063359,
      1,
      0.585535,
      1.110684,
      3,
      3);
commit;
end;
/


