set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9717517';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2005-1-25 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1202',
      NULL,
      86.523916,
      NULL,
      NULL,
      65.075410,
      3,
      NULL,
      NULL,
      '312221',
      5.554954,
      ' 7-13-1994',
      NULL,
      6.411851,
      0,
      NULL,
      0,
      1.427700,
      NULL,
      1,
      1.995955,
      0,
      NULL,
      NULL,
      NULL,
      0.260592,
      1.400056,
      0.044618,
      1,
      0.666158,
      1,
      1,
      NULL,
      0.176553,
      1.716747,
      1.986177,
      1.561774,
      0,
      2.283287,
      NULL,
      1.442138,
      1,
      2,
      NULL,
      NULL,
      NULL,
      0.906845,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.199341,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.281395,
      1.189837,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.942138,
      0,
      0.620333,
      NULL,
      1,
      4,
      NULL,
      0,
      1,
      1,
      1,
      1,
      0.822445,
      2,
      1.057700,
      NULL,
      0.237762,
      0.976443,
      NULL,
      NULL,
      0.264365,
      3,
      0,
      NULL,
      1.313002,
      1.087860,
      0,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.898994,
      1,
      2,
      7.675895,
      3.360946,
      8.887273,
      0,
      3,
      0,
      6.057001,
      NULL,
      0,
      0,
      1.644232,
      1.245413,
      NULL,
      NULL,
      7.471952,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      0,
      0.977607,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.640170,
      0.006657,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.887350,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      9,
      1.137383,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.561217,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.266367,
      NULL,
      0.308668,
      NULL,
      NULL,
      2.129494,
      1.622176,
      3,
      1.326891,
      1.919012,
      NULL,
      1.649870,
      1.904503,
      0.143790,
      1.706392,
      NULL,
      NULL,
      0,
      1,
      0.522295,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.154299,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      NULL,
      '',
      '',
      1,
      '',
      '',
      NULL,
      1.288033,
      '',
      NULL,
      NULL,
      2.184462,
      2,
      3.611697,
      3.588157,
      NULL,
      1,
      1,
      NULL,
      0);
commit;
end;
/


