set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9134183';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1994-4-28 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4',
      '2',
      NULL,
      NULL,
      NULL,
      20.265477,
      6,
      3,
      2,
      '231412',
      0.370696,
      NULL,
      21,
      NULL,
      0,
      NULL,
      1,
      0,
      2,
      0.889848,
      1.926606,
      1,
      0,
      0,
      0,
      0,
      6.598658,
      NULL,
      0.697982,
      1,
      3.060854,
      1,
      4.941453,
      0.445995,
      2.544349,
      NULL,
      1,
      NULL,
      NULL,
      1,
      4,
      0.407592,
      3,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.019696,
      NULL,
      0,
      2.422326,
      1,
      0,
      NULL,
      NULL,
      0,
      3.402295,
      NULL,
      3.623932,
      0.552243,
      2,
      3,
      1,
      1,
      2.993939,
      3,
      0,
      0,
      1.481092,
      2.906779,
      0,
      2,
      1,
      0.820127,
      NULL,
      NULL,
      0.708140,
      NULL,
      NULL,
      1.263748,
      NULL,
      0.312538,
      1.722122,
      5,
      0.882579,
      1.428683,
      0.233060,
      NULL,
      NULL,
      1.156966,
      NULL,
      0,
      4,
      NULL,
      NULL,
      NULL,
      0.874379,
      0.491056,
      NULL,
      1,
      0.831261,
      1,
      1,
      1,
      1.740276,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.675445,
      1,
      2,
      2.526662,
      1,
      3.042393,
      1.622333,
      NULL,
      5,
      0.582554,
      1,
      1,
      5.847359,
      NULL,
      1.350245,
      2,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.583074,
      0,
      0,
      1.939278,
      1,
      0.740640,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.778262,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.746096,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.901678,
      NULL,
      NULL,
      0,
      0,
      1.881673,
      NULL,
      NULL,
      NULL,
      0.684045,
      NULL,
      1.893576,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.843390,
      NULL,
      2.471814,
      0.746389,
      0.937223,
      2.948300,
      0.528498,
      1.445994,
      1,
      1,
      0,
      1.657026,
      0.100349,
      0.020462,
      1.553695,
      1,
      NULL,
      0.657131,
      0,
      1.777850,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      '32011',
      '',
      '',
      0,
      '',
      NULL,
      '',
      0,
      NULL,
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


