set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9134183';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1995-10-06 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1',
      '0',
      NULL,
      NULL,
      '3132222',
      62,
      2,
      1.519534,
      NULL,
      '043133',
      3,
      '11- 9-1978',
      61.551248,
      NULL,
      NULL,
      NULL,
      0,
      1.501252,
      0,
      0.685245,
      1,
      1.920957,
      0,
      0.048652,
      0,
      0,
      7,
      0.425044,
      1.128447,
      1.367528,
      4.261665,
      1.551676,
      3.339853,
      1,
      3,
      5.407250,
      1.291658,
      NULL,
      4.616792,
      NULL,
      4.191333,
      1.983079,
      1.484536,
      1.497431,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.495659,
      1.107049,
      2,
      NULL,
      1,
      1,
      NULL,
      1,
      3.612145,
      1.730598,
      2,
      1,
      NULL,
      1.706544,
      1,
      1.904212,
      NULL,
      NULL,
      0.084059,
      1.860111,
      0,
      2.675564,
      NULL,
      2,
      2.461758,
      0.853679,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.740515,
      NULL,
      1.867168,
      0,
      5,
      0,
      NULL,
      NULL,
      1.294074,
      NULL,
      1,
      0.970753,
      1.701491,
      3.857084,
      NULL,
      1.546131,
      1,
      1.885333,
      0.987677,
      NULL,
      0.366156,
      0,
      2.844331,
      1,
      NULL,
      1.566664,
      1.867099,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.151542,
      1.746561,
      3,
      0,
      2,
      2,
      6.324496,
      5,
      NULL,
      3,
      6.670735,
      3,
      1,
      NULL,
      3,
      0,
      1.483811,
      1,
      9,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      0,
      1.808547,
      1,
      0.390112,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0.962104,
      NULL,
      NULL,
      NULL,
      0.306861,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.777186,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.066314,
      3,
      1,
      3.782968,
      1.494240,
      NULL,
      0.340183,
      0.452503,
      NULL,
      NULL,
      2.378335,
      1,
      0,
      NULL,
      1,
      0.360145,
      NULL,
      0,
      0,
      0.833346,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.274430,
      '22033',
      '',
      '',
      1.779423,
      '',
      '',
      '',
      0,
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


