set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9134183';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1996-9-19 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '01',
      11.522875,
      9,
      '2221231',
      61.404034,
      NULL,
      2.517669,
      0,
      '003121',
      3.591699,
      '10-13-1979',
      12,
      5,
      0.450605,
      NULL,
      3.502756,
      NULL,
      0.742976,
      1,
      0,
      NULL,
      0.125188,
      1.848875,
      0.863582,
      0.656912,
      1.919310,
      0,
      0.906273,
      0.727280,
      0.867306,
      0,
      6.819406,
      NULL,
      1,
      3,
      2.013927,
      0.979881,
      NULL,
      0,
      4,
      2,
      2,
      0.234629,
      NULL,
      NULL,
      0.083564,
      NULL,
      NULL,
      NULL,
      2,
      0,
      2.357486,
      1,
      1,
      NULL,
      0.495487,
      0,
      3,
      3.219623,
      2,
      3,
      0,
      1,
      2.095523,
      1,
      0.587418,
      3,
      0.177088,
      1.197051,
      NULL,
      5.242270,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.221042,
      NULL,
      1,
      0,
      1,
      1.515738,
      NULL,
      0.239330,
      1.394813,
      5.931467,
      2,
      0.320567,
      0.935071,
      1,
      1,
      0.554255,
      NULL,
      1.619040,
      NULL,
      NULL,
      1.935675,
      0.872388,
      NULL,
      2,
      1.720018,
      0,
      7,
      1.221892,
      3,
      1,
      0.766917,
      0,
      2,
      0,
      3.805887,
      1.828797,
      3.727088,
      1.498221,
      NULL,
      5,
      2,
      0.245995,
      NULL,
      3.286208,
      2,
      3,
      0,
      0.280005,
      3.718032,
      1.679902,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      1,
      1,
      0,
      1,
      0.873030,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.357653,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1,
      0.844157,
      0.524886,
      NULL,
      1.616818,
      0,
      0.651545,
      NULL,
      NULL,
      NULL,
      NULL,
      1.816468,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.212296,
      NULL,
      2,
      0,
      3.450377,
      NULL,
      NULL,
      NULL,
      0,
      3.054642,
      NULL,
      NULL,
      0,
      0.131370,
      0.946892,
      NULL,
      0,
      0,
      NULL,
      0.322492,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.302629,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.119451,
      '02120',
      '',
      '',
      1,
      '',
      NULL,
      '',
      0.415478,
      NULL,
      '',
      '',
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


