set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9134183';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-1-30 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '231',
      '00',
      2.476733,
      15,
      '3141032',
      56.117368,
      3,
      NULL,
      3,
      '433020',
      3.432050,
      ' 1-19-1989',
      NULL,
      4,
      1,
      NULL,
      1,
      1.256739,
      1.720498,
      1,
      1,
      0,
      0,
      NULL,
      1.853579,
      1.956291,
      NULL,
      1.649662,
      1,
      7,
      5,
      1,
      5,
      1,
      NULL,
      2.546204,
      3.366424,
      0.695300,
      1.640541,
      1,
      0,
      0.773606,
      1.515992,
      1,
      NULL,
      NULL,
      0.843134,
      NULL,
      NULL,
      7,
      NULL,
      1,
      1.452711,
      1.422457,
      NULL,
      1,
      2,
      1,
      0.709165,
      1,
      NULL,
      3.832408,
      1.464518,
      2,
      NULL,
      0,
      0.841890,
      2,
      1.901509,
      0.790414,
      0,
      9.236873,
      0,
      2,
      1,
      1.896789,
      NULL,
      NULL,
      0.273892,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      2.064445,
      4.782546,
      NULL,
      0.748507,
      1,
      1,
      0,
      5,
      1.151143,
      4.308786,
      1.599467,
      0,
      NULL,
      1,
      NULL,
      NULL,
      1.848325,
      1,
      5.520230,
      NULL,
      NULL,
      NULL,
      1,
      2.419717,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2.195152,
      0.164692,
      1,
      NULL,
      NULL,
      1,
      7,
      9,
      NULL,
      9,
      7,
      6,
      5,
      1.878226,
      5,
      NULL,
      0.625388,
      0,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.929893,
      1,
      2,
      2,
      0.561482,
      5.306590,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.997027,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6.438980,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.213558,
      1,
      4,
      1,
      0,
      NULL,
      0.080143,
      NULL,
      NULL,
      NULL,
      0.779826,
      0.741020,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.842625,
      1,
      NULL,
      0,
      3.651689,
      2,
      1,
      3.750596,
      1.029950,
      0,
      0.149102,
      1,
      0.356007,
      0,
      NULL,
      0,
      0.761191,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2,
      '03312',
      '',
      '',
      1,
      NULL,
      '',
      '',
      0,
      NULL,
      '',
      '',
      3.043321,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


