set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9134183';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-9-05 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '221',
      '12',
      NULL,
      NULL,
      '4333341',
      70.480851,
      NULL,
      2.995061,
      0,
      NULL,
      NULL,
      '11- 6-1990',
      35,
      46,
      1.832808,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1.411903,
      1,
      0,
      2,
      NULL,
      NULL,
      8,
      NULL,
      1,
      NULL,
      1.791159,
      1,
      NULL,
      0,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      0.220705,
      0.889130,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      6,
      1.853702,
      2,
      1,
      1,
      1.113505,
      0,
      NULL,
      0.442381,
      1.825104,
      2,
      0,
      0,
      2.048130,
      0.167515,
      1.861511,
      2,
      2.333743,
      0,
      NULL,
      0,
      1.474382,
      0,
      2,
      NULL,
      1,
      NULL,
      NULL,
      1.270560,
      NULL,
      NULL,
      0,
      NULL,
      4,
      NULL,
      2,
      6.365059,
      NULL,
      NULL,
      1,
      0,
      NULL,
      1.669505,
      1,
      2.013097,
      1.963123,
      1.408254,
      1,
      NULL,
      1,
      NULL,
      0.330549,
      1,
      1.211231,
      NULL,
      NULL,
      0,
      2,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      2.764625,
      NULL,
      0,
      3.680405,
      3.728690,
      2,
      1.343216,
      4.204075,
      0,
      6.972826,
      8,
      7,
      6,
      NULL,
      2,
      3.482703,
      3,
      0.747296,
      0.384618,
      NULL,
      1.746162,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.893696,
      NULL,
      0,
      0,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.116315,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6.420716,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      2.937776,
      1.338718,
      2,
      1.924723,
      NULL,
      NULL,
      NULL,
      1.189810,
      0.250137,
      1.482371,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      2.791686,
      3.869839,
      1,
      2,
      NULL,
      2,
      1.764678,
      3,
      NULL,
      0.178168,
      1.984319,
      0.749380,
      0.867064,
      NULL,
      1,
      1.720949,
      NULL,
      1.781943,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      '20221',
      '',
      NULL,
      NULL,
      '',
      '',
      '',
      0.543786,
      NULL,
      NULL,
      '',
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


