set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9134183';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1998-9-29 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '411',
      '44',
      41,
      14,
      '1034233',
      NULL,
      NULL,
      NULL,
      2,
      '000410',
      4,
      ' 5-17-2003',
      62.878279,
      9.399629,
      0.425570,
      NULL,
      0,
      1.832550,
      3.014241,
      1.351541,
      1,
      1.414255,
      NULL,
      2,
      NULL,
      0,
      2,
      0,
      1,
      8,
      NULL,
      0.865817,
      8,
      NULL,
      0.522347,
      3,
      0,
      NULL,
      3.488303,
      1,
      1,
      1.117740,
      NULL,
      NULL,
      NULL,
      NULL,
      1.247663,
      NULL,
      NULL,
      10.665031,
      4.338742,
      1.145382,
      NULL,
      2,
      0.770782,
      1,
      NULL,
      NULL,
      NULL,
      1,
      2.904435,
      3.704346,
      0,
      3,
      3.106378,
      2.995333,
      1,
      0.376886,
      0.278012,
      0.365968,
      0.209292,
      8,
      1,
      1,
      2,
      1.780665,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      0,
      0,
      7.657066,
      5.011707,
      1.020288,
      1.523955,
      1,
      3,
      0.428827,
      0,
      3.000800,
      NULL,
      1,
      0.846944,
      1.904712,
      0.753774,
      NULL,
      0,
      1.915791,
      1,
      5,
      1.687901,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0.667129,
      0,
      2.031678,
      6,
      NULL,
      1,
      3,
      4.930445,
      1,
      NULL,
      5,
      0,
      0.295063,
      NULL,
      0.893715,
      0.351962,
      1,
      6,
      1.906630,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.065308,
      0.693793,
      0,
      0,
      1,
      NULL,
      3.261618,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.750369,
      NULL,
      1.298836,
      NULL,
      NULL,
      NULL,
      5,
      0.740205,
      7.665143,
      1.388026,
      0.971988,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.377994,
      0.541900,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2.436909,
      1.778093,
      1,
      2.700862,
      3,
      2,
      NULL,
      NULL,
      3,
      NULL,
      0.091697,
      0,
      0.035162,
      0,
      1.993948,
      0.912914,
      0.418695,
      NULL,
      0.715839,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.743951,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      '30000',
      '',
      '',
      0.556844,
      NULL,
      NULL,
      '',
      1,
      '',
      '',
      '',
      4.244755,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


