set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9134183';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-9-07 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '402',
      '40',
      32.473661,
      39.223084,
      '0010131',
      NULL,
      4,
      3.778571,
      1,
      '433413',
      5.554210,
      ' 3-13-1980',
      NULL,
      41,
      1,
      NULL,
      5.613310,
      1.831216,
      3,
      0,
      0.784441,
      NULL,
      0.985378,
      0.167874,
      0,
      1,
      NULL,
      0,
      0,
      6,
      2,
      0,
      4.029484,
      1.153186,
      1.296018,
      2.256183,
      3,
      1,
      NULL,
      0,
      3.440099,
      0.743226,
      0.057560,
      0.242317,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      11,
      9,
      0.852718,
      2.819726,
      3,
      1,
      NULL,
      NULL,
      3.132004,
      1,
      0.732228,
      0,
      NULL,
      1.779285,
      3.123282,
      2.362940,
      1,
      1.898708,
      0.430489,
      0,
      1,
      0.632859,
      NULL,
      1,
      0,
      2.504713,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1,
      5,
      NULL,
      4.516372,
      5.011621,
      NULL,
      NULL,
      NULL,
      1.598822,
      1.529509,
      0,
      1,
      5,
      1.619604,
      NULL,
      1,
      0.777683,
      1.541116,
      NULL,
      0,
      1.662280,
      5.761389,
      NULL,
      1.055302,
      3.685977,
      4,
      1.932830,
      1,
      1.325594,
      1.406425,
      0,
      0.256784,
      1.270564,
      1,
      3.154264,
      4,
      2.151486,
      4,
      NULL,
      8.251604,
      6.874957,
      3.868793,
      NULL,
      6.197444,
      NULL,
      1.862894,
      0.921333,
      NULL,
      NULL,
      1,
      7.213238,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.205216,
      1,
      NULL,
      NULL,
      1.314826,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.001904,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.472213,
      1.268038,
      1,
      NULL,
      NULL,
      NULL,
      1.439538,
      NULL,
      5,
      1.966835,
      0,
      1,
      0.575183,
      NULL,
      NULL,
      NULL,
      0,
      3.040041,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      3.648464,
      3.862339,
      2,
      1,
      NULL,
      NULL,
      3.248180,
      2.574589,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.683379,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      '',
      0,
      NULL,
      '',
      '',
      0,
      '',
      NULL,
      '',
      3,
      NULL,
      2,
      0,
      4,
      0,
      NULL,
      0.668000,
      2.370400);
commit;
end;
/


