set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9134183';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-2-16 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '30011113',
      NULL,
      22.753943,
      '2320202',
      163.018243,
      NULL,
      0.930269,
      2,
      '240300',
      4,
      ' 4- 0-2000',
      NULL,
      31,
      NULL,
      NULL,
      1.128695,
      1,
      3,
      1.714271,
      0,
      NULL,
      0,
      2,
      1.659025,
      0.391399,
      NULL,
      1.901390,
      0,
      5.982545,
      6.239842,
      1,
      NULL,
      1,
      1,
      NULL,
      3,
      1,
      9,
      1,
      2.911667,
      0,
      4.528554,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      1,
      3.964739,
      1,
      0,
      1.456276,
      1.674587,
      0,
      3.948924,
      0.982801,
      3.022362,
      3,
      0,
      2,
      NULL,
      2,
      3.788553,
      NULL,
      1,
      1.839206,
      0,
      7.303269,
      1,
      1,
      1,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      0,
      1.373426,
      2,
      3.584482,
      5,
      1,
      1.850414,
      2.132635,
      7,
      1.787499,
      0,
      5.068141,
      1,
      0.450266,
      0.193048,
      0,
      1.681477,
      NULL,
      0,
      NULL,
      1,
      0,
      0.668454,
      0,
      5.939506,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.384224,
      0.367225,
      4,
      0,
      5,
      8.926829,
      8.713173,
      2,
      8.643969,
      7,
      9.268503,
      NULL,
      0.056910,
      0,
      NULL,
      3.864881,
      1.681262,
      1.596823,
      1.071492,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.619270,
      1,
      2,
      0,
      0,
      0.648786,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2.574560,
      1.500589,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.803637,
      NULL,
      1.073525,
      0,
      1.099734,
      NULL,
      NULL,
      NULL,
      1,
      3,
      0.973634,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.153811,
      NULL,
      NULL,
      3.734383,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      3.257442,
      0.079015,
      NULL,
      NULL,
      0.701436,
      0,
      1.941076,
      0.799478,
      1.118799,
      1.913135,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.800452,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.048684,
      '22400',
      NULL,
      '',
      0,
      NULL,
      '',
      NULL,
      1,
      '',
      NULL,
      NULL,
      NULL,
      2.532637,
      1,
      NULL,
      0.757131,
      NULL,
      1,
      3,
      2);
commit;
end;
/


