set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6218579';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1993-12-06 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1',
      NULL,
      NULL,
      NULL,
      '1203244',
      19,
      1,
      3.027027,
      0,
      '420013',
      0,
      ' 6-23-1996',
      5.786907,
      NULL,
      0.963928,
      NULL,
      0,
      0,
      1,
      1.661059,
      0,
      NULL,
      NULL,
      NULL,
      0.118743,
      0,
      7.214056,
      0.810577,
      1.113489,
      3.008268,
      NULL,
      0.237106,
      NULL,
      1,
      7.595570,
      4,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.778735,
      NULL,
      1,
      NULL,
      NULL,
      0.841677,
      NULL,
      NULL,
      3,
      0,
      NULL,
      1,
      0,
      NULL,
      2,
      2.132018,
      2,
      NULL,
      0.114177,
      1,
      3,
      0,
      3,
      1.852238,
      NULL,
      0.782389,
      0,
      2.846364,
      NULL,
      NULL,
      5.405842,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.326356,
      NULL,
      1.483763,
      0.494761,
      0,
      NULL,
      1,
      0.203604,
      NULL,
      0,
      NULL,
      0.567585,
      0.682333,
      1,
      1.216297,
      1,
      1.756667,
      1.250257,
      0,
      NULL,
      NULL,
      0.114809,
      0.453885,
      1.949299,
      5.512333,
      NULL,
      NULL,
      3.845738,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      1.782747,
      4,
      0,
      4.739555,
      9,
      1.085973,
      9.342736,
      4.306753,
      0.735362,
      7,
      0.353986,
      NULL,
      NULL,
      3.664915,
      4.742417,
      0,
      0,
      1,
      4.409784,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      NULL,
      1,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8,
      0.784653,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      1.000743,
      NULL,
      NULL,
      NULL,
      3.690290,
      0,
      2.627578,
      7.268753,
      0,
      NULL,
      1.027328,
      NULL,
      NULL,
      NULL,
      3.578148,
      2,
      0.701025,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.520879,
      0,
      0.677811,
      0.797168,
      1,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      1.372263,
      1.175526,
      NULL,
      1.992483,
      1.018980,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      '43112',
      '',
      '',
      1.945498,
      '',
      NULL,
      '',
      1,
      '1024',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


