set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6218579';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1994-5-24 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '2',
      NULL,
      NULL,
      '0344212',
      2,
      2,
      3.088383,
      0,
      NULL,
      0.093007,
      ' 4-20-1995',
      37.896613,
      NULL,
      0,
      NULL,
      1.928484,
      3.473802,
      0.533321,
      1,
      0,
      0,
      0,
      1.582930,
      1,
      1.482539,
      2.101119,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      0.337814,
      0.392271,
      0.333784,
      NULL,
      7,
      0,
      0.184623,
      0,
      2.965594,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      0.496950,
      1.709907,
      1.298223,
      NULL,
      1.597761,
      2.610691,
      NULL,
      0.901504,
      1.320865,
      1,
      0.177883,
      1.425694,
      0.663456,
      2.278353,
      0.851453,
      2.843442,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.463997,
      0,
      1,
      0.347767,
      0.677635,
      NULL,
      NULL,
      0.389113,
      NULL,
      NULL,
      0.063524,
      0.684357,
      NULL,
      0.881366,
      0,
      0.577158,
      1,
      1.777171,
      1.387098,
      0,
      1.992443,
      0.337791,
      NULL,
      0.669046,
      0,
      0.867039,
      0.458307,
      1,
      1.024105,
      NULL,
      0.977974,
      4,
      0,
      0,
      NULL,
      0.916515,
      1.040006,
      NULL,
      NULL,
      1.120278,
      NULL,
      2,
      0.998213,
      0,
      3.674158,
      1,
      NULL,
      7.698033,
      9,
      3.439045,
      9,
      4.638827,
      5,
      NULL,
      4,
      3.340656,
      NULL,
      1.513193,
      2.314435,
      1.719743,
      0,
      NULL,
      1.233381,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.075523,
      0,
      0,
      NULL,
      1,
      NULL,
      1.802995,
      0.987310,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8,
      NULL,
      NULL,
      3.532135,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      3.826885,
      0.495923,
      0,
      0,
      0,
      3,
      7.398776,
      1,
      1,
      2,
      0,
      1.995207,
      NULL,
      NULL,
      0,
      7.783118,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.936962,
      1,
      NULL,
      0,
      3,
      0.966433,
      0.202752,
      1.815387,
      1,
      NULL,
      1.150695,
      NULL,
      1,
      NULL,
      1.102137,
      NULL,
      0,
      1,
      0.910424,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      '22304',
      NULL,
      '',
      1,
      '',
      '',
      '',
      0.674844,
      '1243',
      NULL,
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


