set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6218579';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1994-11-04 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '3',
      NULL,
      NULL,
      '2410212',
      2,
      NULL,
      NULL,
      3,
      '324104',
      1.374097,
      ' 7- 2-1981',
      35.775102,
      NULL,
      0.195476,
      NULL,
      1,
      0,
      1.413269,
      1.440918,
      1.153486,
      0,
      NULL,
      0.524830,
      NULL,
      NULL,
      1,
      1.416145,
      1.926189,
      0,
      0,
      0,
      0,
      NULL,
      1,
      NULL,
      0.273319,
      0,
      4,
      1,
      3.012446,
      1.066737,
      NULL,
      1,
      NULL,
      NULL,
      0.210588,
      NULL,
      NULL,
      1.446230,
      1.347791,
      NULL,
      0.617982,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.784615,
      5,
      5.898631,
      1,
      2,
      0,
      NULL,
      NULL,
      NULL,
      0.545748,
      NULL,
      NULL,
      1,
      1.170767,
      1.038667,
      0.274004,
      1.467756,
      0.868602,
      1.952807,
      0.129334,
      0.855971,
      1,
      0.687599,
      1,
      1.846515,
      0,
      1.596126,
      0,
      1.747952,
      0.270226,
      0.525440,
      NULL,
      1.336941,
      1,
      NULL,
      0.103534,
      NULL,
      1,
      5,
      2.368806,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      3,
      0,
      2,
      4.572492,
      1,
      4.566428,
      3.833402,
      0,
      2,
      11,
      NULL,
      4.780441,
      6.839414,
      5,
      NULL,
      NULL,
      NULL,
      5.101744,
      0.664241,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.091790,
      NULL,
      0,
      0.177014,
      0.830638,
      0,
      1.406472,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8.107851,
      2,
      3.704474,
      2.747413,
      NULL,
      NULL,
      1.569056,
      NULL,
      1.266696,
      6.066963,
      1.134701,
      2,
      1.429623,
      NULL,
      0,
      2.760654,
      0,
      8.488937,
      3.432143,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.883214,
      6.819290,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.898101,
      1,
      NULL,
      0,
      0,
      NULL,
      0.798965,
      3.574137,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1.318971,
      NULL,
      0.613491,
      1,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.137180,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      '10011',
      '',
      '',
      NULL,
      '',
      NULL,
      '',
      3.512021,
      '0413',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


