set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6218579';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1995-5-08 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3',
      NULL,
      NULL,
      NULL,
      NULL,
      61,
      2,
      3,
      NULL,
      NULL,
      1.530832,
      NULL,
      15,
      NULL,
      0,
      NULL,
      NULL,
      1,
      3.914447,
      0.464688,
      1.293968,
      1,
      0.623971,
      1.747034,
      0.091309,
      1.777917,
      NULL,
      NULL,
      0,
      1,
      0.269267,
      0,
      NULL,
      0.821828,
      NULL,
      1.794690,
      3,
      0.539143,
      0.473398,
      1,
      0.015986,
      NULL,
      1,
      1,
      NULL,
      NULL,
      0,
      0,
      0.670107,
      3.456527,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.513153,
      2,
      3.231272,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.357948,
      1.560877,
      0,
      1.378581,
      1.646437,
      0.429343,
      0.668285,
      0.813235,
      0,
      1,
      1.951747,
      1,
      1.626536,
      NULL,
      0,
      0.037456,
      1.960677,
      NULL,
      NULL,
      0,
      NULL,
      0.421692,
      0.888081,
      0.210913,
      1,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      0.808198,
      3,
      4,
      NULL,
      5.943780,
      7.233045,
      1.062568,
      NULL,
      3.255231,
      2,
      9,
      11.870307,
      3,
      4,
      10.457267,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.770383,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.968711,
      1,
      NULL,
      0,
      1.467473,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.644193,
      0.259982,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.116452,
      3.719865,
      NULL,
      NULL,
      NULL,
      NULL,
      4.784897,
      0.112385,
      2,
      4,
      0.196882,
      1,
      5.990873,
      0.457578,
      NULL,
      NULL,
      2,
      4.778344,
      0.337883,
      1.781755,
      4,
      4.635497,
      NULL,
      NULL,
      0.922528,
      2,
      1,
      NULL,
      3,
      2,
      NULL,
      1.406883,
      0.017538,
      0.650130,
      3.628098,
      NULL,
      0,
      0.466260,
      NULL,
      1.853965,
      0.809977,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      '00134',
      '',
      '',
      1.734264,
      NULL,
      NULL,
      '',
      NULL,
      '1034',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


