set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8204649';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1988-5-31 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1',
      '3',
      NULL,
      NULL,
      '3132033',
      12.515327,
      3,
      NULL,
      0,
      NULL,
      3.693614,
      ' 9-23-1984',
      NULL,
      NULL,
      0,
      NULL,
      1.355029,
      1.227507,
      0.297002,
      0,
      0,
      0,
      3,
      0.690079,
      1,
      0.233137,
      NULL,
      1,
      1.943401,
      0.385105,
      1.695808,
      1,
      6.556412,
      1.405362,
      3,
      7.888692,
      0.384672,
      0,
      5.380658,
      1,
      4,
      2,
      NULL,
      0,
      NULL,
      NULL,
      1.962921,
      NULL,
      NULL,
      0.418697,
      NULL,
      1,
      NULL,
      NULL,
      1,
      1.434567,
      2.808203,
      NULL,
      0.015560,
      2.948131,
      1.351619,
      NULL,
      NULL,
      NULL,
      3.630661,
      1,
      NULL,
      3.507772,
      1.166331,
      0,
      1.660888,
      NULL,
      1,
      0,
      NULL,
      0,
      NULL,
      NULL,
      1.098985,
      NULL,
      NULL,
      1.784717,
      1.649580,
      1,
      NULL,
      2,
      1,
      NULL,
      1.216005,
      3.179618,
      1.439011,
      0.861534,
      0,
      NULL,
      3,
      0,
      0.248414,
      1.279916,
      1,
      NULL,
      NULL,
      1.523606,
      0,
      5,
      1,
      NULL,
      0,
      0.408994,
      1.998339,
      1.429955,
      1.170091,
      NULL,
      0,
      1,
      0.373443,
      5.427823,
      0,
      0,
      NULL,
      5.798510,
      6.996751,
      3,
      6.946485,
      NULL,
      4,
      5.679158,
      NULL,
      0,
      3,
      2.698393,
      0,
      0,
      8.911959,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      0,
      1.712523,
      NULL,
      2.613732,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      3,
      2,
      0.217963,
      2.778789,
      1.926003,
      1.218617,
      0.034307,
      1.860315,
      0.378061,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.793325,
      0,
      NULL,
      2,
      0,
      1,
      1.025941,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0.344714,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.784749,
      3.129614,
      3.998444,
      2.019964,
      3.107319,
      NULL,
      NULL,
      1,
      1.440236,
      1,
      NULL,
      NULL,
      NULL,
      1,
      0.148150,
      0.820311,
      1.719397,
      0.764579,
      1.068079,
      0.240920,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.825495,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.266250,
      '04133',
      '',
      NULL,
      0.368273,
      '',
      NULL,
      NULL,
      0.456129,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


