set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8204649';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1988-6-03 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3',
      '3',
      NULL,
      NULL,
      NULL,
      12,
      NULL,
      1,
      NULL,
      '314314',
      1.304445,
      ' 2-22-1984',
      54.542398,
      NULL,
      NULL,
      NULL,
      0,
      2,
      1.346332,
      NULL,
      NULL,
      1.823527,
      NULL,
      1.416335,
      0.362200,
      NULL,
      2.055665,
      1.362814,
      3,
      0.542334,
      0.131052,
      0.546538,
      4,
      NULL,
      6.211848,
      2,
      0.157523,
      0.262996,
      3.765867,
      1,
      4.529904,
      NULL,
      0.901751,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.063197,
      1.124418,
      2,
      0,
      0,
      3.994045,
      3.547635,
      0.479778,
      NULL,
      0,
      1,
      1.032471,
      0.216239,
      1,
      3,
      0,
      0.485431,
      2,
      NULL,
      1,
      0,
      6,
      0,
      1,
      0.264791,
      1.136593,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.284479,
      2.962569,
      1.852862,
      0,
      5,
      1,
      3,
      0.082717,
      3,
      NULL,
      1.333219,
      1,
      NULL,
      1,
      0,
      NULL,
      1,
      1,
      NULL,
      NULL,
      1,
      0.218033,
      2.525035,
      0.583514,
      1.904030,
      0,
      0.815087,
      0.411479,
      5,
      0,
      0,
      1,
      1.478178,
      2,
      0.025695,
      0.337944,
      3.135429,
      5,
      4,
      0,
      NULL,
      5.206412,
      5.260457,
      5,
      NULL,
      NULL,
      3.018052,
      4.707801,
      2,
      NULL,
      NULL,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.832704,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      4.547915,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      8,
      1.256568,
      0.678328,
      3,
      NULL,
      NULL,
      0.470662,
      0.321039,
      1,
      1.447164,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.999874,
      NULL,
      0.980940,
      3.111374,
      4.790666,
      2,
      1,
      NULL,
      NULL,
      NULL,
      0.239072,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.586523,
      1,
      2,
      NULL,
      0,
      2.446014,
      NULL,
      3.753603,
      1.185072,
      1,
      1,
      0.979132,
      1,
      1,
      0.486947,
      NULL,
      0.916196,
      0.027042,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      '20432',
      '',
      '',
      1.941687,
      NULL,
      '',
      '',
      NULL,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


