set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8204649';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1988-10-25 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1',
      NULL,
      NULL,
      NULL,
      '3002312',
      25.388879,
      2,
      1.041972,
      1,
      '141224',
      3.191201,
      ' 9- 0-2002',
      41.207525,
      NULL,
      0.536981,
      NULL,
      2.422932,
      3.974480,
      1.532045,
      0.146144,
      1,
      1.574458,
      3.675510,
      1.962360,
      1.387828,
      0.153121,
      NULL,
      NULL,
      0,
      NULL,
      0,
      1.530903,
      4,
      1,
      3,
      NULL,
      1,
      0.093469,
      NULL,
      0,
      0,
      1.736461,
      1.178570,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      3,
      NULL,
      1,
      1,
      1.852100,
      0.203471,
      NULL,
      NULL,
      NULL,
      3.648518,
      1,
      1.209736,
      1,
      0.206242,
      NULL,
      3.835818,
      1,
      1.946754,
      0.931982,
      1.992355,
      0.965995,
      NULL,
      1,
      0,
      0.160467,
      1,
      NULL,
      NULL,
      0.984195,
      NULL,
      NULL,
      0,
      5,
      0,
      NULL,
      4.673194,
      NULL,
      4.414283,
      1.961011,
      1.747011,
      1,
      NULL,
      3,
      1,
      5,
      1.896096,
      1,
      0.351675,
      0.833011,
      1,
      NULL,
      NULL,
      2.544284,
      1.397270,
      0.071314,
      3,
      0,
      5.247363,
      NULL,
      5.442406,
      0.539053,
      1,
      NULL,
      NULL,
      0,
      NULL,
      1,
      1.436679,
      1,
      NULL,
      0.794922,
      3.120447,
      7.680069,
      4,
      5,
      4,
      5,
      NULL,
      5.066907,
      2.745124,
      1.050342,
      0,
      NULL,
      2.785620,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.246511,
      0,
      NULL,
      NULL,
      2,
      5,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      6,
      2.550484,
      NULL,
      0.538795,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      3.875603,
      3.536720,
      0.314366,
      NULL,
      2.516456,
      1.187448,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.571404,
      NULL,
      1.078079,
      1.502047,
      1,
      3,
      2.584695,
      1.239107,
      0,
      2.057393,
      0.510091,
      1,
      NULL,
      0.758051,
      0.807585,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.509785,
      '31001',
      '',
      '',
      0.576400,
      '',
      '',
      NULL,
      0.560151,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


