set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8204649';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-6-10 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '1',
      NULL,
      NULL,
      NULL,
      18,
      3,
      1.745394,
      1,
      '134210',
      0,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      1,
      1.799827,
      1.091036,
      0,
      NULL,
      NULL,
      0.924255,
      1.012499,
      0.830461,
      0,
      1.758902,
      0.487786,
      NULL,
      NULL,
      1,
      1,
      3,
      1.067264,
      0.638984,
      1.289607,
      1,
      1,
      7,
      1,
      NULL,
      3.263950,
      0.264829,
      0,
      NULL,
      NULL,
      0.679648,
      NULL,
      NULL,
      3.471986,
      1,
      1.680799,
      3.162251,
      NULL,
      1,
      2,
      0,
      NULL,
      NULL,
      NULL,
      1,
      1.180991,
      1.079457,
      1,
      1.224959,
      3.356330,
      NULL,
      0.343093,
      0.972862,
      0.104871,
      0.039509,
      0.165421,
      1,
      1,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.900349,
      3.508205,
      1,
      5.854447,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0.924079,
      0,
      NULL,
      0.784055,
      0.298324,
      NULL,
      NULL,
      NULL,
      0.343989,
      NULL,
      2.090374,
      0,
      0,
      NULL,
      5,
      0.235652,
      0,
      0.207213,
      1,
      5,
      NULL,
      2.185314,
      NULL,
      1.204564,
      1,
      5,
      3,
      2.168228,
      NULL,
      0.780237,
      3,
      5,
      NULL,
      NULL,
      3.638845,
      5,
      3,
      1.510876,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      NULL,
      NULL,
      0,
      0.088898,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.353162,
      NULL,
      1.267275,
      2.968456,
      1,
      1.484846,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.432766,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      5,
      1.655331,
      0.538478,
      NULL,
      0.876832,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1.802973,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      3,
      1.439463,
      1,
      0,
      1,
      1.908889,
      0.904084,
      0,
      NULL,
      1.403075,
      NULL,
      1,
      1.918039,
      0.575595,
      0.208704,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      '40140',
      '',
      '',
      0,
      '',
      '',
      '',
      0.132020,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


