set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8204649';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-12-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0',
      '3',
      NULL,
      NULL,
      '0334140',
      28,
      NULL,
      0,
      3,
      '040234',
      3.088516,
      ' 6-29-1984',
      43.650177,
      NULL,
      0,
      NULL,
      NULL,
      2.442716,
      1,
      NULL,
      3,
      1,
      1,
      0,
      0,
      NULL,
      0,
      NULL,
      NULL,
      1.734929,
      2.364631,
      2.651567,
      4,
      1.296717,
      9,
      1.838684,
      1,
      1.106996,
      9,
      0,
      0,
      0,
      0,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      4,
      0.924548,
      1.711115,
      1,
      1.798689,
      0,
      1.765579,
      0.601834,
      1,
      3,
      NULL,
      2,
      2,
      0,
      NULL,
      1,
      0.793633,
      NULL,
      0,
      1.748011,
      1,
      0,
      1,
      0,
      1,
      0.755187,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.359864,
      5.438199,
      2,
      1.998933,
      2,
      NULL,
      1,
      1.984770,
      0,
      2.104247,
      5.421650,
      NULL,
      0,
      4.837995,
      1,
      1.293877,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      0.997746,
      NULL,
      0.548894,
      NULL,
      0,
      0.202360,
      4.399034,
      3,
      1.583488,
      1.160900,
      NULL,
      NULL,
      1,
      5,
      7,
      6,
      7,
      1.208968,
      6.983365,
      6.189244,
      2.833123,
      1.688381,
      NULL,
      0.145543,
      NULL,
      2.509922,
      NULL,
      0,
      3.423013,
      1.223788,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      NULL,
      0,
      4,
      3.853008,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      9.858371,
      1,
      0.499768,
      3.060758,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.417908,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.854708,
      1,
      7.079698,
      5.289458,
      4.464237,
      2,
      0.054854,
      NULL,
      NULL,
      NULL,
      NULL,
      8.286235,
      1.891807,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.081461,
      0.141085,
      2.959251,
      1,
      0,
      NULL,
      NULL,
      0,
      3.448705,
      0,
      0.395026,
      1.569913,
      NULL,
      1.361416,
      1.313084,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.683259,
      '23124',
      '',
      '',
      0.012508,
      '',
      '',
      NULL,
      0.063594,
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


